/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRQueue;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RDelayedQueue;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;

public class TracingRDelayedQueue<V>
extends TracingRQueue<V>
implements RDelayedQueue<V> {
    private final RDelayedQueue<V> queue;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRDelayedQueue(RDelayedQueue<V> queue, TracingRedissonHelper tracingRedissonHelper) {
        super(queue, tracingRedissonHelper);
        this.queue = queue;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public void offer(V e, long delay, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("offer", (RObject)this.queue);
        span.setTag("element", TracingHelper.nullable(e));
        span.setTag("delay", (Number)delay);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        this.tracingRedissonHelper.decorate(span, () -> this.queue.offer(e, delay, timeUnit));
    }

    public RFuture<Void> offerAsync(V e, long delay, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("offerAsync", (RObject)this.queue);
        span.setTag("element", TracingHelper.nullable(e));
        span.setTag("delay", (Number)delay);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.offerAsync(e, delay, timeUnit));
    }

    public void destroy() {
        Span span = this.tracingRedissonHelper.buildSpan("destroy", (RObject)this.queue);
        this.tracingRedissonHelper.decorate(span, () -> this.queue.destroy());
    }
}

