/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.redisson.api.RFuture;
import org.redisson.api.RKeys;
import org.redisson.api.RObject;
import org.redisson.api.RType;

public class TracingRKeys
implements RKeys {
    private final RKeys keys;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRKeys(RKeys keys, TracingRedissonHelper tracingRedissonHelper) {
        this.keys = keys;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public boolean move(String name, int database) {
        Span span = this.tracingRedissonHelper.buildSpan("move");
        span.setTag("name", TracingHelper.nullable((Object)name));
        span.setTag("database", (Number)database);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.keys.move(name, database));
    }

    public void migrate(String name, String host, int port, int database, long timeout) {
        Span span = this.tracingRedissonHelper.buildSpan("migrate");
        span.setTag("name", TracingHelper.nullable((Object)name));
        span.setTag("host", TracingHelper.nullable((Object)host));
        span.setTag("port", (Number)port);
        span.setTag("database", (Number)database);
        span.setTag("timeout", (Number)timeout);
        this.tracingRedissonHelper.decorate(span, () -> this.keys.migrate(name, host, port, database, timeout));
    }

    public void copy(String name, String host, int port, int database, long timeout) {
        Span span = this.tracingRedissonHelper.buildSpan("copy");
        span.setTag("name", TracingHelper.nullable((Object)name));
        span.setTag("host", TracingHelper.nullable((Object)host));
        span.setTag("port", (Number)port);
        span.setTag("database", (Number)database);
        span.setTag("timeout", (Number)timeout);
        this.tracingRedissonHelper.decorate(span, () -> this.keys.copy(name, host, port, database, timeout));
    }

    public boolean expire(String name, long timeToLive, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("expire");
        span.setTag("name", TracingHelper.nullable((Object)name));
        span.setTag("timeToLive", (Number)timeToLive);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.keys.expire(name, timeToLive, timeUnit));
    }

    public boolean expireAt(String name, long timestamp) {
        Span span = this.tracingRedissonHelper.buildSpan("expireAt");
        span.setTag("name", TracingHelper.nullable((Object)name));
        span.setTag("timestamp", (Number)timestamp);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.keys.expireAt(name, timestamp));
    }

    public boolean clearExpire(String name) {
        Span span = this.tracingRedissonHelper.buildSpan("clearExpire");
        span.setTag("name", TracingHelper.nullable((Object)name));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.keys.clearExpire(name));
    }

    public boolean renamenx(String oldName, String newName) {
        Span span = this.tracingRedissonHelper.buildSpan("renamenx");
        span.setTag("oldName", TracingHelper.nullable((Object)oldName));
        span.setTag("newName", TracingHelper.nullable((Object)newName));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.keys.renamenx(oldName, newName));
    }

    public void rename(String currentName, String newName) {
        Span span = this.tracingRedissonHelper.buildSpan("rename");
        span.setTag("currentName", TracingHelper.nullable((Object)currentName));
        span.setTag("newName", TracingHelper.nullable((Object)newName));
        this.tracingRedissonHelper.decorate(span, () -> this.keys.rename(currentName, newName));
    }

    public long remainTimeToLive(String name) {
        Span span = this.tracingRedissonHelper.buildSpan("remainTimeToLive");
        span.setTag("name", TracingHelper.nullable((Object)name));
        return (Long)this.tracingRedissonHelper.decorate(span, () -> this.keys.remainTimeToLive(name));
    }

    public long touch(String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("touch");
        span.setTag("names", Arrays.toString(names));
        return (Long)this.tracingRedissonHelper.decorate(span, () -> this.keys.touch(names));
    }

    public long countExists(String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("countExists");
        span.setTag("names", Arrays.toString(names));
        return (Long)this.tracingRedissonHelper.decorate(span, () -> this.keys.countExists(names));
    }

    public RType getType(String key) {
        Span span = this.tracingRedissonHelper.buildSpan("getType");
        span.setTag("key", TracingHelper.nullable((Object)key));
        return (RType)this.tracingRedissonHelper.decorate(span, () -> this.keys.getType(key));
    }

    public int getSlot(String key) {
        Span span = this.tracingRedissonHelper.buildSpan("getSlot");
        span.setTag("key", TracingHelper.nullable((Object)key));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.keys.getSlot(key));
    }

    public Iterable<String> getKeysByPattern(String pattern) {
        Span span = this.tracingRedissonHelper.buildSpan("getKeysByPattern");
        span.setTag("pattern", TracingHelper.nullable((Object)pattern));
        return (Iterable)this.tracingRedissonHelper.decorate(span, () -> this.keys.getKeysByPattern(pattern));
    }

    public Iterable<String> getKeysByPattern(String pattern, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("getKeysByPattern");
        span.setTag("pattern", TracingHelper.nullable((Object)pattern));
        span.setTag("count", (Number)count);
        return (Iterable)this.tracingRedissonHelper.decorate(span, () -> this.keys.getKeysByPattern(pattern, count));
    }

    public Iterable<String> getKeys() {
        Span span = this.tracingRedissonHelper.buildSpan("getKeys");
        return (Iterable)this.tracingRedissonHelper.decorate(span, () -> this.keys.getKeys());
    }

    public Iterable<String> getKeys(int count) {
        Span span = this.tracingRedissonHelper.buildSpan("getKeys");
        span.setTag("count", (Number)count);
        return (Iterable)this.tracingRedissonHelper.decorate(span, () -> this.keys.getKeys(count));
    }

    public Stream<String> getKeysStreamByPattern(String pattern) {
        Span span = this.tracingRedissonHelper.buildSpan("getKeysStreamByPattern");
        span.setTag("pattern", TracingHelper.nullable((Object)pattern));
        return (Stream)this.tracingRedissonHelper.decorate(span, () -> this.keys.getKeysStreamByPattern(pattern));
    }

    public Stream<String> getKeysStreamByPattern(String pattern, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("getKeysStreamByPattern");
        span.setTag("pattern", TracingHelper.nullable((Object)pattern));
        span.setTag("count", (Number)count);
        return (Stream)this.tracingRedissonHelper.decorate(span, () -> this.keys.getKeysStreamByPattern(pattern, count));
    }

    public Stream<String> getKeysStream() {
        Span span = this.tracingRedissonHelper.buildSpan("getKeysStream");
        return (Stream)this.tracingRedissonHelper.decorate(span, () -> this.keys.getKeysStream());
    }

    public Stream<String> getKeysStream(int count) {
        Span span = this.tracingRedissonHelper.buildSpan("getKeysStream");
        span.setTag("count", (Number)count);
        return (Stream)this.tracingRedissonHelper.decorate(span, () -> this.keys.getKeysStream(count));
    }

    public String randomKey() {
        Span span = this.tracingRedissonHelper.buildSpan("randomKey");
        return (String)this.tracingRedissonHelper.decorate(span, () -> ((RKeys)this.keys).randomKey());
    }

    @Deprecated
    public Collection<String> findKeysByPattern(String pattern) {
        Span span = this.tracingRedissonHelper.buildSpan("findKeysByPattern");
        span.setTag("pattern", TracingHelper.nullable((Object)pattern));
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.keys.findKeysByPattern(pattern));
    }

    public long deleteByPattern(String pattern) {
        Span span = this.tracingRedissonHelper.buildSpan("deleteByPattern");
        span.setTag("pattern", TracingHelper.nullable((Object)pattern));
        return (Long)this.tracingRedissonHelper.decorate(span, () -> this.keys.deleteByPattern(pattern));
    }

    public long delete(RObject ... objects) {
        Span span = this.tracingRedissonHelper.buildSpan("delete");
        span.setTag("objects", Arrays.toString(objects));
        return (Long)this.tracingRedissonHelper.decorate(span, () -> this.keys.delete(objects));
    }

    public long delete(String ... keys) {
        Span span = this.tracingRedissonHelper.buildSpan("delete");
        span.setTag("keys", Arrays.toString(keys));
        return (Long)this.tracingRedissonHelper.decorate(span, () -> this.keys.delete(keys));
    }

    public long unlink(String ... keys) {
        Span span = this.tracingRedissonHelper.buildSpan("unlink");
        span.setTag("keys", Arrays.toString(keys));
        return (Long)this.tracingRedissonHelper.decorate(span, () -> this.keys.unlink(keys));
    }

    public long count() {
        Span span = this.tracingRedissonHelper.buildSpan("count");
        return (Long)this.tracingRedissonHelper.decorate(span, () -> ((RKeys)this.keys).count());
    }

    public void flushdb() {
        Span span = this.tracingRedissonHelper.buildSpan("flushdb");
        this.tracingRedissonHelper.decorate(span, () -> ((RKeys)this.keys).flushdb());
    }

    public void flushdbParallel() {
        Span span = this.tracingRedissonHelper.buildSpan("flushdbParallel");
        this.tracingRedissonHelper.decorate(span, () -> ((RKeys)this.keys).flushdbParallel());
    }

    public void flushall() {
        Span span = this.tracingRedissonHelper.buildSpan("flushall");
        this.tracingRedissonHelper.decorate(span, () -> ((RKeys)this.keys).flushall());
    }

    public void flushallParallel() {
        Span span = this.tracingRedissonHelper.buildSpan("flushallParallel");
        this.tracingRedissonHelper.decorate(span, () -> ((RKeys)this.keys).flushallParallel());
    }

    public RFuture<Boolean> moveAsync(String name, int database) {
        Span span = this.tracingRedissonHelper.buildSpan("moveAsync");
        span.setTag("name", TracingHelper.nullable((Object)name));
        span.setTag("database", (Number)database);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.keys.moveAsync(name, database));
    }

    public RFuture<Void> migrateAsync(String name, String host, int port, int database, long timeout) {
        Span span = this.tracingRedissonHelper.buildSpan("migrateAsync");
        span.setTag("name", TracingHelper.nullable((Object)name));
        span.setTag("host", TracingHelper.nullable((Object)host));
        span.setTag("port", (Number)port);
        span.setTag("database", (Number)database);
        span.setTag("timeout", (Number)timeout);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.keys.migrateAsync(name, host, port, database, timeout));
    }

    public RFuture<Void> copyAsync(String name, String host, int port, int database, long timeout) {
        Span span = this.tracingRedissonHelper.buildSpan("copyAsync");
        span.setTag("name", TracingHelper.nullable((Object)name));
        span.setTag("host", TracingHelper.nullable((Object)host));
        span.setTag("port", (Number)port);
        span.setTag("database", (Number)database);
        span.setTag("timeout", (Number)timeout);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.keys.copyAsync(name, host, port, database, timeout));
    }

    public RFuture<Boolean> expireAsync(String name, long timeToLive, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("expireAsync");
        span.setTag("name", TracingHelper.nullable((Object)name));
        span.setTag("timeToLive", (Number)timeToLive);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.keys.expireAsync(name, timeToLive, timeUnit));
    }

    public RFuture<Boolean> expireAtAsync(String name, long timestamp) {
        Span span = this.tracingRedissonHelper.buildSpan("expireAtAsync");
        span.setTag("name", TracingHelper.nullable((Object)name));
        span.setTag("timestamp", (Number)timestamp);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.keys.expireAtAsync(name, timestamp));
    }

    public RFuture<Boolean> clearExpireAsync(String name) {
        Span span = this.tracingRedissonHelper.buildSpan("clearExpireAsync");
        span.setTag("name", TracingHelper.nullable((Object)name));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.keys.clearExpireAsync(name));
    }

    public RFuture<Boolean> renamenxAsync(String oldName, String newName) {
        Span span = this.tracingRedissonHelper.buildSpan("renamenxAsync");
        span.setTag("oldName", TracingHelper.nullable((Object)oldName));
        span.setTag("newName", TracingHelper.nullable((Object)newName));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.keys.renamenxAsync(oldName, newName));
    }

    public RFuture<Void> renameAsync(String currentName, String newName) {
        Span span = this.tracingRedissonHelper.buildSpan("renameAsync");
        span.setTag("currentName", TracingHelper.nullable((Object)currentName));
        span.setTag("newName", TracingHelper.nullable((Object)newName));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.keys.renameAsync(currentName, newName));
    }

    public RFuture<Long> remainTimeToLiveAsync(String name) {
        Span span = this.tracingRedissonHelper.buildSpan("remainTimeToLiveAsync");
        span.setTag("name", TracingHelper.nullable((Object)name));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.keys.remainTimeToLiveAsync(name));
    }

    public RFuture<Long> touchAsync(String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("touchAsync");
        span.setTag("names", Arrays.toString(names));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.keys.touchAsync(names));
    }

    public RFuture<Long> countExistsAsync(String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("countExistsAsync");
        span.setTag("names", Arrays.toString(names));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.keys.countExistsAsync(names));
    }

    public RFuture<RType> getTypeAsync(String key) {
        Span span = this.tracingRedissonHelper.buildSpan("getTypeAsync");
        span.setTag("key", TracingHelper.nullable((Object)key));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.keys.getTypeAsync(key));
    }

    public RFuture<Integer> getSlotAsync(String key) {
        Span span = this.tracingRedissonHelper.buildSpan("getSlotAsync");
        span.setTag("key", TracingHelper.nullable((Object)key));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.keys.getSlotAsync(key));
    }

    public RFuture<String> randomKeyAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("randomKeyAsync");
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RKeys)this.keys).randomKeyAsync());
    }

    @Deprecated
    public RFuture<Collection<String>> findKeysByPatternAsync(String pattern) {
        Span span = this.tracingRedissonHelper.buildSpan("findKeysByPatternAsync");
        span.setTag("pattern", TracingHelper.nullable((Object)pattern));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.keys.findKeysByPatternAsync(pattern));
    }

    public RFuture<Long> deleteByPatternAsync(String pattern) {
        Span span = this.tracingRedissonHelper.buildSpan("deleteByPatternAsync");
        span.setTag("pattern", TracingHelper.nullable((Object)pattern));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.keys.deleteByPatternAsync(pattern));
    }

    public RFuture<Long> deleteAsync(RObject ... objects) {
        Span span = this.tracingRedissonHelper.buildSpan("deleteAsync");
        span.setTag("objects", Arrays.toString(objects));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.keys.deleteAsync(objects));
    }

    public RFuture<Long> deleteAsync(String ... keys) {
        Span span = this.tracingRedissonHelper.buildSpan("deleteAsync");
        span.setTag("keys", Arrays.toString(keys));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.keys.deleteAsync(keys));
    }

    public RFuture<Long> unlinkAsync(String ... keys) {
        Span span = this.tracingRedissonHelper.buildSpan("unlinkAsync");
        span.setTag("keys", Arrays.toString(keys));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.keys.unlinkAsync(keys));
    }

    public RFuture<Long> countAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("countAsync");
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RKeys)this.keys).countAsync());
    }

    public RFuture<Void> flushdbAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("flushdbAsync");
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RKeys)this.keys).flushdbAsync());
    }

    public RFuture<Void> flushallAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("flushallAsync");
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RKeys)this.keys).flushallAsync());
    }

    public RFuture<Void> flushdbParallelAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("flushdbParallelAsync");
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RKeys)this.keys).flushdbParallelAsync());
    }

    public RFuture<Void> flushallParallelAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("flushallParallelAsync");
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RKeys)this.keys).flushallParallelAsync());
    }
}

