/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRSortedSet;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Collection;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.api.RLexSortedSet;
import org.redisson.api.RObject;

public class TracingRLexSortedSet
extends TracingRSortedSet<String>
implements RLexSortedSet {
    private final RLexSortedSet set;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRLexSortedSet(RLexSortedSet set, TracingRedissonHelper tracingRedissonHelper) {
        super(set, tracingRedissonHelper);
        this.set = set;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public String pollFirst() {
        Span span = this.tracingRedissonHelper.buildSpan("pollFirst", (RObject)this.set);
        return (String)this.tracingRedissonHelper.decorate(span, () -> ((RLexSortedSet)this.set).pollFirst());
    }

    public String pollLast() {
        Span span = this.tracingRedissonHelper.buildSpan("pollLast", (RObject)this.set);
        return (String)this.tracingRedissonHelper.decorate(span, () -> ((RLexSortedSet)this.set).pollLast());
    }

    public Integer revRank(String o) {
        Span span = this.tracingRedissonHelper.buildSpan("revRank", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.revRank(o));
    }

    public int removeRangeTail(String fromElement, boolean fromInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("removeRangeTail", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.removeRangeTail(fromElement, fromInclusive));
    }

    public int removeRangeHead(String toElement, boolean toInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("removeRangeHead", (RObject)this.set);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.removeRangeHead(toElement, toInclusive));
    }

    public int removeRange(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("removeRange", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.removeRange(fromElement, fromInclusive, toElement, toInclusive));
    }

    public int countTail(String fromElement, boolean fromInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("countTail", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.countTail(fromElement, fromInclusive));
    }

    public int countHead(String toElement, boolean toInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("countHead", (RObject)this.set);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.countHead(toElement, toInclusive));
    }

    public Collection<String> rangeTail(String fromElement, boolean fromInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeTail", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.rangeTail(fromElement, fromInclusive));
    }

    public Collection<String> rangeHead(String toElement, boolean toInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeHead", (RObject)this.set);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.rangeHead(toElement, toInclusive));
    }

    public Collection<String> range(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("range", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.range(fromElement, fromInclusive, toElement, toInclusive));
    }

    public Collection<String> rangeTail(String fromElement, boolean fromInclusive, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeTail", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.rangeTail(fromElement, fromInclusive, offset, count));
    }

    public Collection<String> rangeHead(String toElement, boolean toInclusive, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeHead", (RObject)this.set);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.rangeHead(toElement, toInclusive, offset, count));
    }

    public Collection<String> range(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("range", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.range(fromElement, fromInclusive, toElement, toInclusive, offset, count));
    }

    public Collection<String> rangeTailReversed(String fromElement, boolean fromInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeTailReversed", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.rangeTailReversed(fromElement, fromInclusive));
    }

    public Collection<String> rangeHeadReversed(String toElement, boolean toInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeHeadReversed", (RObject)this.set);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.rangeHeadReversed(toElement, toInclusive));
    }

    public Collection<String> rangeReversed(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeReversed", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.rangeReversed(fromElement, fromInclusive, toElement, toInclusive));
    }

    public Collection<String> rangeTailReversed(String fromElement, boolean fromInclusive, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeTailReversed", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.rangeTailReversed(fromElement, fromInclusive, offset, count));
    }

    public Collection<String> rangeHeadReversed(String toElement, boolean toInclusive, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeHeadReversed", (RObject)this.set);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.rangeHeadReversed(toElement, toInclusive, offset, count));
    }

    public Collection<String> rangeReversed(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeReversed", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.rangeReversed(fromElement, fromInclusive, toElement, toInclusive, offset, count));
    }

    public int count(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("count", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.count(fromElement, fromInclusive, toElement, toInclusive));
    }

    public Integer rank(String o) {
        Span span = this.tracingRedissonHelper.buildSpan("rank", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.rank(o));
    }

    public Collection<String> range(int startIndex, int endIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("range", (RObject)this.set);
        span.setTag("startIndex", (Number)startIndex);
        span.setTag("endIndex", (Number)endIndex);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.range(startIndex, endIndex));
    }

    public RFuture<String> pollLastAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("pollLastAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RLexSortedSet)this.set).pollLastAsync());
    }

    public RFuture<String> pollFirstAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("pollFirstAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RLexSortedSet)this.set).pollFirstAsync());
    }

    public RFuture<String> firstAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("firstAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RLexSortedSet)this.set).firstAsync());
    }

    public RFuture<String> lastAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("lastAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RLexSortedSet)this.set).lastAsync());
    }

    @Override
    public RFuture<Collection<String>> readAllAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("readAllAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RLexSortedSet)this.set).readAllAsync());
    }

    public RFuture<Integer> removeRangeAsync(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("removeRangeAsync", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.removeRangeAsync(fromElement, fromInclusive, toElement, toInclusive));
    }

    public RFuture<Integer> removeRangeTailAsync(String fromElement, boolean fromInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("removeRangeTailAsync", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.removeRangeTailAsync(fromElement, fromInclusive));
    }

    public RFuture<Integer> removeRangeHeadAsync(String toElement, boolean toInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("removeRangeHeadAsync", (RObject)this.set);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.removeRangeHeadAsync(toElement, toInclusive));
    }

    public RFuture<Integer> countTailAsync(String fromElement, boolean fromInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("countTailAsync", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.countTailAsync(fromElement, fromInclusive));
    }

    public RFuture<Integer> countHeadAsync(String toElement, boolean toInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("countHeadAsync", (RObject)this.set);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.countHeadAsync(toElement, toInclusive));
    }

    public RFuture<Collection<String>> rangeTailAsync(String fromElement, boolean fromInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeTailAsync", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.rangeTailAsync(fromElement, fromInclusive));
    }

    public RFuture<Collection<String>> rangeHeadAsync(String toElement, boolean toInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeHeadAsync", (RObject)this.set);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.rangeHeadAsync(toElement, toInclusive));
    }

    public RFuture<Collection<String>> rangeAsync(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeAsync", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.rangeAsync(fromElement, fromInclusive, toElement, toInclusive));
    }

    public RFuture<Collection<String>> rangeTailAsync(String fromElement, boolean fromInclusive, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeTailAsync", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.rangeTailAsync(fromElement, fromInclusive, offset, count));
    }

    public RFuture<Collection<String>> rangeHeadAsync(String toElement, boolean toInclusive, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeHeadAsync", (RObject)this.set);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.rangeHeadAsync(toElement, toInclusive, offset, count));
    }

    public RFuture<Collection<String>> rangeAsync(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeAsync", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.rangeAsync(fromElement, fromInclusive, toElement, toInclusive, offset, count));
    }

    public RFuture<Collection<String>> rangeTailReversedAsync(String fromElement, boolean fromInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeTailReversedAsync", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.rangeTailReversedAsync(fromElement, fromInclusive));
    }

    public RFuture<Collection<String>> rangeHeadReversedAsync(String toElement, boolean toInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeHeadReversedAsync", (RObject)this.set);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.rangeHeadReversedAsync(toElement, toInclusive));
    }

    public RFuture<Collection<String>> rangeReversedAsync(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeReversedAsync", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.rangeReversedAsync(fromElement, fromInclusive, toElement, toInclusive));
    }

    public RFuture<Collection<String>> rangeTailReversedAsync(String fromElement, boolean fromInclusive, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeTailReversedAsync", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.rangeTailReversedAsync(fromElement, fromInclusive, offset, count));
    }

    public RFuture<Collection<String>> rangeHeadReversedAsync(String toElement, boolean toInclusive, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeHeadReversedAsync", (RObject)this.set);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.rangeHeadReversedAsync(toElement, toInclusive, offset, count));
    }

    public RFuture<Collection<String>> rangeReversedAsync(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("rangeReversedAsync", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.rangeReversedAsync(fromElement, fromInclusive, toElement, toInclusive, offset, count));
    }

    public RFuture<Integer> countAsync(String fromElement, boolean fromInclusive, String toElement, boolean toInclusive) {
        Span span = this.tracingRedissonHelper.buildSpan("countAsync", (RObject)this.set);
        span.setTag("fromElement", TracingHelper.nullable((Object)fromElement));
        span.setTag("fromInclusive", fromInclusive);
        span.setTag("toElement", TracingHelper.nullable((Object)toElement));
        span.setTag("toInclusive", toInclusive);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.countAsync(fromElement, fromInclusive, toElement, toInclusive));
    }

    public RFuture<Integer> rankAsync(String o) {
        Span span = this.tracingRedissonHelper.buildSpan("rankAsync", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.rankAsync(o));
    }

    public RFuture<Collection<String>> rangeAsync(int startIndex, int endIndex) {
        Span span = this.tracingRedissonHelper.buildSpan("rankAsync", (RObject)this.set);
        span.setTag("startIndex", (Number)startIndex);
        span.setTag("endIndex", (Number)endIndex);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.rangeAsync(startIndex, endIndex));
    }

    public RFuture<Integer> revRankAsync(String o) {
        return this.set.revRankAsync(o);
    }

    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("retainAllAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.retainAllAsync(c));
    }

    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAllAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.removeAllAsync(c));
    }

    public RFuture<Boolean> containsAsync(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("containsAsync", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.containsAsync(o));
    }

    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("containsAllAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.containsAllAsync(c));
    }

    @Override
    public RFuture<Boolean> removeAsync(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAsync", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.removeAsync(o));
    }

    public RFuture<Integer> sizeAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("sizeAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RLexSortedSet)this.set).sizeAsync());
    }

    @Override
    public RFuture<Boolean> addAsync(String e) {
        Span span = this.tracingRedissonHelper.buildSpan("addAsync", (RObject)this.set);
        span.setTag("element", TracingHelper.nullable((Object)e));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.addAsync((Object)e));
    }

    public RFuture<Boolean> addAllAsync(Collection<? extends String> c) {
        Span span = this.tracingRedissonHelper.buildSpan("addAllAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.addAllAsync(c));
    }

    public boolean expire(long timeToLive, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("expire", (RObject)this.set);
        span.setTag("timeToLive", (Number)timeToLive);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.expire(timeToLive, timeUnit));
    }

    public boolean expireAt(long timestamp) {
        Span span = this.tracingRedissonHelper.buildSpan("expireAt", (RObject)this.set);
        span.setTag("timestamp", (Number)timestamp);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.expireAt(timestamp));
    }

    public boolean expireAt(Date timestamp) {
        Span span = this.tracingRedissonHelper.buildSpan("expireAt", (RObject)this.set);
        span.setTag("timestamp", TracingHelper.nullable((Object)timestamp));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.expireAt(timestamp));
    }

    public boolean clearExpire() {
        Span span = this.tracingRedissonHelper.buildSpan("clearExpire", (RObject)this.set);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> ((RLexSortedSet)this.set).clearExpire());
    }

    public long remainTimeToLive() {
        Span span = this.tracingRedissonHelper.buildSpan("remainTimeToLive", (RObject)this.set);
        return (Long)this.tracingRedissonHelper.decorate(span, () -> ((RLexSortedSet)this.set).remainTimeToLive());
    }

    public RFuture<Boolean> expireAsync(long timeToLive, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("expireAsync", (RObject)this.set);
        span.setTag("timeToLive", (Number)timeToLive);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.expireAsync(timeToLive, timeUnit));
    }

    public RFuture<Boolean> expireAtAsync(Date timestamp) {
        Span span = this.tracingRedissonHelper.buildSpan("expireAtAsync", (RObject)this.set);
        span.setTag("timestamp", TracingHelper.nullable((Object)timestamp));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.expireAtAsync(timestamp));
    }

    public RFuture<Boolean> expireAtAsync(long timestamp) {
        Span span = this.tracingRedissonHelper.buildSpan("expireAtAsync", (RObject)this.set);
        span.setTag("timestamp", (Number)timestamp);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.expireAtAsync(timestamp));
    }

    public RFuture<Boolean> clearExpireAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("clearExpireAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RLexSortedSet)this.set).clearExpireAsync());
    }

    public RFuture<Long> remainTimeToLiveAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("remainTimeToLiveAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RLexSortedSet)this.set).remainTimeToLiveAsync());
    }
}

