/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRExpirable;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RLongAdder;
import org.redisson.api.RObject;

public class TracingRLongAdder
extends TracingRExpirable
implements RLongAdder {
    private final RLongAdder longAdder;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRLongAdder(RLongAdder longAdder, TracingRedissonHelper tracingRedissonHelper) {
        super((RExpirable)longAdder, tracingRedissonHelper);
        this.longAdder = longAdder;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public void add(long x) {
        Span span = this.tracingRedissonHelper.buildSpan("add", (RObject)this.longAdder);
        span.setTag("value", (Number)x);
        this.tracingRedissonHelper.decorate(span, () -> this.longAdder.add(x));
    }

    public void increment() {
        Span span = this.tracingRedissonHelper.buildSpan("increment", (RObject)this.longAdder);
        this.tracingRedissonHelper.decorate(span, () -> ((RLongAdder)this.longAdder).increment());
    }

    public void decrement() {
        Span span = this.tracingRedissonHelper.buildSpan("decrement", (RObject)this.longAdder);
        this.tracingRedissonHelper.decorate(span, () -> ((RLongAdder)this.longAdder).decrement());
    }

    public long sum() {
        Span span = this.tracingRedissonHelper.buildSpan("sum", (RObject)this.longAdder);
        return (Long)this.tracingRedissonHelper.decorate(span, () -> ((RLongAdder)this.longAdder).sum());
    }

    public void reset() {
        Span span = this.tracingRedissonHelper.buildSpan("reset", (RObject)this.longAdder);
        this.tracingRedissonHelper.decorate(span, () -> ((RLongAdder)this.longAdder).reset());
    }

    public RFuture<Long> sumAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("sumAsync", (RObject)this.longAdder);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RLongAdder)this.longAdder).sumAsync());
    }

    public RFuture<Long> sumAsync(long timeout, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("sumAsync", (RObject)this.longAdder);
        span.setTag("timeout", (Number)timeout);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.longAdder.sumAsync(timeout, timeUnit));
    }

    public RFuture<Void> resetAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("resetAsync", (RObject)this.longAdder);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RLongAdder)this.longAdder).resetAsync());
    }

    public RFuture<Void> resetAsync(long timeout, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("resetAsync", (RObject)this.longAdder);
        span.setTag("timeout", (Number)timeout);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.longAdder.resetAsync(timeout, timeUnit));
    }

    public void destroy() {
        Span span = this.tracingRedissonHelper.buildSpan("destroy", (RObject)this.longAdder);
        this.tracingRedissonHelper.decorate(span, () -> ((RLongAdder)this.longAdder).destroy());
    }
}

