/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRCountDownLatch;
import io.opentracing.contrib.redis.redisson.TracingRExpirable;
import io.opentracing.contrib.redis.redisson.TracingRLock;
import io.opentracing.contrib.redis.redisson.TracingRMapReduce;
import io.opentracing.contrib.redis.redisson.TracingRPermitExpirableSemaphore;
import io.opentracing.contrib.redis.redisson.TracingRReadWriteLock;
import io.opentracing.contrib.redis.redisson.TracingRSemaphore;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.Function;
import org.redisson.api.RCountDownLatch;
import org.redisson.api.RExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RMap;
import org.redisson.api.RObject;
import org.redisson.api.RPermitExpirableSemaphore;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RSemaphore;
import org.redisson.api.mapreduce.RMapReduce;

public class TracingRMap<K, V>
extends TracingRExpirable
implements RMap<K, V> {
    private final RMap<K, V> map;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRMap(RMap<K, V> map, TracingRedissonHelper tracingRedissonHelper) {
        super((RExpirable)map, tracingRedissonHelper);
        this.map = map;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public void loadAll(boolean replaceExistingValues, int parallelism) {
        Span span = this.tracingRedissonHelper.buildSpan("loadAll", (RObject)this.map);
        span.setTag("replaceExistingValues", replaceExistingValues);
        span.setTag("parallelism", (Number)parallelism);
        this.tracingRedissonHelper.decorate(span, () -> this.map.loadAll(replaceExistingValues, parallelism));
    }

    public void loadAll(Set<? extends K> keys, boolean replaceExistingValues, int parallelism) {
        Span span = this.tracingRedissonHelper.buildSpan("loadAll", (RObject)this.map);
        span.setTag("keys", TracingHelper.collectionToString(keys));
        span.setTag("replaceExistingValues", replaceExistingValues);
        span.setTag("parallelism", (Number)parallelism);
        this.tracingRedissonHelper.decorate(span, () -> this.map.loadAll(keys, replaceExistingValues, parallelism));
    }

    public V get(Object key) {
        Span span = this.tracingRedissonHelper.buildSpan("get", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable((Object)key));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.map.get(key));
    }

    public V put(K key, V value) {
        Span span = this.tracingRedissonHelper.buildSpan("put", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.map.put(key, value));
    }

    public V putIfAbsent(K key, V value) {
        Span span = this.tracingRedissonHelper.buildSpan("putIfAbsent", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.map.putIfAbsent(key, value));
    }

    public <KOut, VOut> RMapReduce<K, V, KOut, VOut> mapReduce() {
        return new TracingRMapReduce(this.map.mapReduce(), this.tracingRedissonHelper);
    }

    public RCountDownLatch getCountDownLatch(K key) {
        return new TracingRCountDownLatch(this.map.getCountDownLatch(key), this.tracingRedissonHelper);
    }

    public RPermitExpirableSemaphore getPermitExpirableSemaphore(K key) {
        return new TracingRPermitExpirableSemaphore(this.map.getPermitExpirableSemaphore(key), this.tracingRedissonHelper);
    }

    public RSemaphore getSemaphore(K key) {
        return new TracingRSemaphore(this.map.getSemaphore(key), this.tracingRedissonHelper);
    }

    public RLock getFairLock(K key) {
        return new TracingRLock(this.map.getFairLock(key), this.tracingRedissonHelper);
    }

    public RReadWriteLock getReadWriteLock(K key) {
        return new TracingRReadWriteLock(this.map.getReadWriteLock(key), this.tracingRedissonHelper);
    }

    public RLock getLock(K key) {
        return new TracingRLock(this.map.getLock(key), this.tracingRedissonHelper);
    }

    public int valueSize(K key) {
        Span span = this.tracingRedissonHelper.buildSpan("valueSize", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.map.valueSize(key));
    }

    public V addAndGet(K key, Number delta) {
        Span span = this.tracingRedissonHelper.buildSpan("addAndGet", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("delta", TracingHelper.nullable((Object)delta));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.map.addAndGet(key, delta));
    }

    public V remove(Object key) {
        Span span = this.tracingRedissonHelper.buildSpan("remove", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable((Object)key));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.map.remove(key));
    }

    public V replace(K key, V value) {
        Span span = this.tracingRedissonHelper.buildSpan("replace", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.map.replace(key, value));
    }

    public boolean replace(K key, V oldValue, V newValue) {
        Span span = this.tracingRedissonHelper.buildSpan("replace", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("oldValue", TracingHelper.nullable(oldValue));
        span.setTag("newValue", TracingHelper.nullable(newValue));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.map.replace(key, oldValue, newValue));
    }

    public boolean remove(Object key, Object value) {
        Span span = this.tracingRedissonHelper.buildSpan("remove", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable((Object)key));
        span.setTag("value", TracingHelper.nullable((Object)value));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.map.remove(key, value));
    }

    public void putAll(Map<? extends K, ? extends V> map) {
        Span span = this.tracingRedissonHelper.buildSpan("putAll", (RObject)this.map);
        span.setTag("map", TracingHelper.mapToString(map));
        this.tracingRedissonHelper.decorate(span, () -> this.map.putAll(map));
    }

    public void putAll(Map<? extends K, ? extends V> map, int batchSize) {
        Span span = this.tracingRedissonHelper.buildSpan("putAll", (RObject)this.map);
        span.setTag("map", TracingHelper.mapToString(map));
        span.setTag("batchSize", (Number)batchSize);
        this.tracingRedissonHelper.decorate(span, () -> this.map.putAll(map, batchSize));
    }

    public Map<K, V> getAll(Set<K> keys) {
        Span span = this.tracingRedissonHelper.buildSpan("getAll", (RObject)this.map);
        span.setTag("keys", TracingHelper.collectionToString(keys));
        return (Map)this.tracingRedissonHelper.decorate(span, () -> this.map.getAll(keys));
    }

    public long fastRemove(K ... keys) {
        Span span = this.tracingRedissonHelper.buildSpan("fastRemove", (RObject)this.map);
        span.setTag("keys", Arrays.toString(keys));
        return (Long)this.tracingRedissonHelper.decorate(span, () -> this.map.fastRemove(keys));
    }

    public boolean fastPut(K key, V value) {
        Span span = this.tracingRedissonHelper.buildSpan("fastPut", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.map.fastPut(key, value));
    }

    public boolean fastReplace(K key, V value) {
        Span span = this.tracingRedissonHelper.buildSpan("fastReplace", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.map.fastReplace(key, value));
    }

    public boolean fastPutIfAbsent(K key, V value) {
        Span span = this.tracingRedissonHelper.buildSpan("fastPutIfAbsent", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.map.fastPutIfAbsent(key, value));
    }

    public Set<K> readAllKeySet() {
        Span span = this.tracingRedissonHelper.buildSpan("readAllKeySet", (RObject)this.map);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.map.readAllKeySet());
    }

    public Collection<V> readAllValues() {
        Span span = this.tracingRedissonHelper.buildSpan("readAllValues", (RObject)this.map);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.map.readAllValues());
    }

    public Set<Map.Entry<K, V>> readAllEntrySet() {
        Span span = this.tracingRedissonHelper.buildSpan("readAllEntrySet", (RObject)this.map);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.map.readAllEntrySet());
    }

    public Map<K, V> readAllMap() {
        Span span = this.tracingRedissonHelper.buildSpan("readAllMap", (RObject)this.map);
        return (Map)this.tracingRedissonHelper.decorate(span, () -> this.map.readAllMap());
    }

    public Set<K> keySet() {
        Span span = this.tracingRedissonHelper.buildSpan("keySet", (RObject)this.map);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.map.keySet());
    }

    public Set<K> keySet(int count) {
        Span span = this.tracingRedissonHelper.buildSpan("keySet", (RObject)this.map);
        span.setTag("count", (Number)count);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.map.keySet(count));
    }

    public Set<K> keySet(String pattern, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("keySet", (RObject)this.map);
        span.setTag("pattern", pattern);
        span.setTag("count", (Number)count);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.map.keySet(pattern, count));
    }

    public Set<K> keySet(String pattern) {
        Span span = this.tracingRedissonHelper.buildSpan("keySet", (RObject)this.map);
        span.setTag("pattern", pattern);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.map.keySet(pattern));
    }

    public Collection<V> values() {
        Span span = this.tracingRedissonHelper.buildSpan("values", (RObject)this.map);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.map.values());
    }

    public Collection<V> values(String keyPattern) {
        Span span = this.tracingRedissonHelper.buildSpan("values", (RObject)this.map);
        span.setTag("keyPattern", keyPattern);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.map.values(keyPattern));
    }

    public Collection<V> values(String keyPattern, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("values", (RObject)this.map);
        span.setTag("keyPattern", keyPattern);
        span.setTag("count", (Number)count);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.map.values(keyPattern, count));
    }

    public Collection<V> values(int count) {
        Span span = this.tracingRedissonHelper.buildSpan("values", (RObject)this.map);
        span.setTag("count", (Number)count);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.map.values(count));
    }

    public Set<Map.Entry<K, V>> entrySet() {
        Span span = this.tracingRedissonHelper.buildSpan("entrySet", (RObject)this.map);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.map.entrySet());
    }

    public Set<Map.Entry<K, V>> entrySet(String keyPattern) {
        Span span = this.tracingRedissonHelper.buildSpan("entrySet", (RObject)this.map);
        span.setTag("keyPattern", keyPattern);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.map.entrySet(keyPattern));
    }

    public Set<Map.Entry<K, V>> entrySet(String keyPattern, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("entrySet", (RObject)this.map);
        span.setTag("keyPattern", keyPattern);
        span.setTag("count", (Number)count);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.map.entrySet(keyPattern, count));
    }

    public Set<Map.Entry<K, V>> entrySet(int count) {
        Span span = this.tracingRedissonHelper.buildSpan("entrySet", (RObject)this.map);
        span.setTag("count", (Number)count);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.map.entrySet(count));
    }

    public V getOrDefault(Object key, V defaultValue) {
        Span span = this.tracingRedissonHelper.buildSpan("getOrDefault", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable((Object)key));
        span.setTag("defaultValue", TracingHelper.nullable(defaultValue));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.map.getOrDefault(key, defaultValue));
    }

    public void forEach(BiConsumer<? super K, ? super V> action) {
        Span span = this.tracingRedissonHelper.buildSpan("forEach", (RObject)this.map);
        span.setTag("action", TracingHelper.nullable(action));
        this.tracingRedissonHelper.decorate(span, () -> this.map.forEach(action));
    }

    public void replaceAll(BiFunction<? super K, ? super V, ? extends V> function) {
        Span span = this.tracingRedissonHelper.buildSpan("replaceAll", (RObject)this.map);
        span.setTag("function", TracingHelper.nullable(function));
        this.tracingRedissonHelper.decorate(span, () -> this.map.replaceAll(function));
    }

    public V computeIfAbsent(K key, Function<? super K, ? extends V> mappingFunction) {
        Span span = this.tracingRedissonHelper.buildSpan("computeIfAbsent", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("mappingFunction", TracingHelper.nullable(mappingFunction));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.map.computeIfAbsent(key, mappingFunction));
    }

    public V computeIfPresent(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Span span = this.tracingRedissonHelper.buildSpan("computeIfPresent", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("remappingFunction", TracingHelper.nullable(remappingFunction));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.map.computeIfPresent(key, remappingFunction));
    }

    public V compute(K key, BiFunction<? super K, ? super V, ? extends V> remappingFunction) {
        Span span = this.tracingRedissonHelper.buildSpan("compute", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("remappingFunction", TracingHelper.nullable(remappingFunction));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.map.compute(key, remappingFunction));
    }

    public V merge(K key, V value, BiFunction<? super V, ? super V, ? extends V> remappingFunction) {
        Span span = this.tracingRedissonHelper.buildSpan("merge", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("remappingFunction", TracingHelper.nullable(remappingFunction));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.map.merge(key, value, remappingFunction));
    }

    public int size() {
        Span span = this.tracingRedissonHelper.buildSpan("size", (RObject)this.map);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.map.size());
    }

    public boolean isEmpty() {
        Span span = this.tracingRedissonHelper.buildSpan("isEmpty", (RObject)this.map);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.map.isEmpty());
    }

    public boolean containsKey(Object key) {
        Span span = this.tracingRedissonHelper.buildSpan("containsKey", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable((Object)key));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.map.containsKey(key));
    }

    public boolean containsValue(Object value) {
        Span span = this.tracingRedissonHelper.buildSpan("containsValue", (RObject)this.map);
        span.setTag("value", TracingHelper.nullable((Object)value));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.map.containsValue(value));
    }

    public void clear() {
        Span span = this.tracingRedissonHelper.buildSpan("clear", (RObject)this.map);
        this.tracingRedissonHelper.decorate(span, () -> this.map.clear());
    }

    @Override
    public boolean equals(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("equals", (RObject)this.map);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.map.equals(o));
    }

    @Override
    public int hashCode() {
        Span span = this.tracingRedissonHelper.buildSpan("hashCode", (RObject)this.map);
        return (Integer)this.tracingRedissonHelper.decorate(span, this.map::hashCode);
    }

    public RFuture<Void> loadAllAsync(boolean replaceExistingValues, int parallelism) {
        Span span = this.tracingRedissonHelper.buildSpan("loadAllAsync", (RObject)this.map);
        span.setTag("replaceExistingValues", replaceExistingValues);
        span.setTag("parallelism", (Number)parallelism);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.loadAllAsync(replaceExistingValues, parallelism));
    }

    public RFuture<Void> loadAllAsync(Set<? extends K> keys, boolean replaceExistingValues, int parallelism) {
        Span span = this.tracingRedissonHelper.buildSpan("loadAllAsync", (RObject)this.map);
        span.setTag("replaceExistingValues", replaceExistingValues);
        span.setTag("parallelism", (Number)parallelism);
        span.setTag("keys", TracingHelper.collectionToString(keys));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.loadAllAsync(keys, replaceExistingValues, parallelism));
    }

    public RFuture<Integer> valueSizeAsync(K key) {
        Span span = this.tracingRedissonHelper.buildSpan("valueSizeAsync", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.valueSizeAsync(key));
    }

    public RFuture<Map<K, V>> getAllAsync(Set<K> keys) {
        Span span = this.tracingRedissonHelper.buildSpan("getAllAsync", (RObject)this.map);
        span.setTag("keys", TracingHelper.collectionToString(keys));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.getAllAsync(keys));
    }

    public RFuture<Void> putAllAsync(Map<? extends K, ? extends V> map) {
        Span span = this.tracingRedissonHelper.buildSpan("putAllAsync", (RObject)this.map);
        span.setTag("map", TracingHelper.mapToString(map));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.putAllAsync(map));
    }

    public RFuture<Void> putAllAsync(Map<? extends K, ? extends V> map, int batchSize) {
        Span span = this.tracingRedissonHelper.buildSpan("putAllAsync", (RObject)this.map);
        span.setTag("map", TracingHelper.mapToString(map));
        span.setTag("batchSize", (Number)batchSize);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.putAllAsync(map, batchSize));
    }

    public RFuture<V> addAndGetAsync(K key, Number value) {
        Span span = this.tracingRedissonHelper.buildSpan("addAndGetAsync", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable((Object)value));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.addAndGetAsync(key, value));
    }

    public RFuture<Boolean> containsValueAsync(Object value) {
        Span span = this.tracingRedissonHelper.buildSpan("containsValueAsync", (RObject)this.map);
        span.setTag("value", TracingHelper.nullable((Object)value));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.containsValueAsync(value));
    }

    public RFuture<Boolean> containsKeyAsync(Object key) {
        Span span = this.tracingRedissonHelper.buildSpan("containsKeyAsync", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable((Object)key));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.containsKeyAsync(key));
    }

    public RFuture<Integer> sizeAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("sizeAsync", (RObject)this.map);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.sizeAsync());
    }

    public RFuture<Long> fastRemoveAsync(K ... keys) {
        Span span = this.tracingRedissonHelper.buildSpan("fastRemoveAsync", (RObject)this.map);
        span.setTag("keys", Arrays.toString(keys));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.fastRemoveAsync(keys));
    }

    public RFuture<Boolean> fastPutAsync(K key, V value) {
        Span span = this.tracingRedissonHelper.buildSpan("fastPutAsync", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.fastPutAsync(key, value));
    }

    public RFuture<Boolean> fastReplaceAsync(K key, V value) {
        Span span = this.tracingRedissonHelper.buildSpan("fastReplaceAsync", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.fastReplaceAsync(key, value));
    }

    public RFuture<Boolean> fastPutIfAbsentAsync(K key, V value) {
        Span span = this.tracingRedissonHelper.buildSpan("fastPutIfAbsentAsync", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.fastPutIfAbsentAsync(key, value));
    }

    public RFuture<Set<K>> readAllKeySetAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("readAllKeySetAsync", (RObject)this.map);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.readAllKeySetAsync());
    }

    public RFuture<Collection<V>> readAllValuesAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("readAllValuesAsync", (RObject)this.map);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.readAllValuesAsync());
    }

    public RFuture<Set<Map.Entry<K, V>>> readAllEntrySetAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("readAllEntrySetAsync", (RObject)this.map);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.readAllEntrySetAsync());
    }

    public RFuture<Map<K, V>> readAllMapAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("readAllMapAsync", (RObject)this.map);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.readAllMapAsync());
    }

    public RFuture<V> getAsync(K key) {
        Span span = this.tracingRedissonHelper.buildSpan("getAsync", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.getAsync(key));
    }

    public RFuture<V> putAsync(K key, V value) {
        Span span = this.tracingRedissonHelper.buildSpan("putAsync", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.putAsync(key, value));
    }

    public RFuture<V> removeAsync(K key) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAsync", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.removeAsync(key));
    }

    public RFuture<V> replaceAsync(K key, V value) {
        Span span = this.tracingRedissonHelper.buildSpan("replaceAsync", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.replaceAsync(key, value));
    }

    public RFuture<Boolean> replaceAsync(K key, V oldValue, V newValue) {
        Span span = this.tracingRedissonHelper.buildSpan("replaceAsync", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("oldValue", TracingHelper.nullable(oldValue));
        span.setTag("newValue", TracingHelper.nullable(newValue));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.replaceAsync(key, oldValue, newValue));
    }

    public RFuture<Boolean> removeAsync(Object key, Object value) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAsync", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable((Object)key));
        span.setTag("value", TracingHelper.nullable((Object)value));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.removeAsync(key, value));
    }

    public RFuture<V> putIfAbsentAsync(K key, V value) {
        Span span = this.tracingRedissonHelper.buildSpan("putIfAbsentAsync", (RObject)this.map);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("value", TracingHelper.nullable(value));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.map.putIfAbsentAsync(key, value));
    }
}

