/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Arrays;
import java.util.concurrent.TimeUnit;
import org.redisson.api.ObjectListener;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;
import org.redisson.client.codec.Codec;

public class TracingRObject
implements RObject {
    private final RObject object;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRObject(RObject object, TracingRedissonHelper tracingRedissonHelper) {
        this.object = object;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public long sizeInMemory() {
        Span span = this.tracingRedissonHelper.buildSpan("sizeInMemory", this.object);
        return (Long)this.tracingRedissonHelper.decorate(span, () -> ((RObject)this.object).sizeInMemory());
    }

    public void restore(byte[] state) {
        Span span = this.tracingRedissonHelper.buildSpan("restore", this.object);
        span.setTag("state", Arrays.toString(state));
        this.tracingRedissonHelper.decorate(span, () -> this.object.restore(state));
    }

    public void restore(byte[] state, long timeToLive, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("restore", this.object);
        span.setTag("state", Arrays.toString(state));
        span.setTag("timeToLive", (Number)timeToLive);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        this.tracingRedissonHelper.decorate(span, () -> this.object.restore(state, timeToLive, timeUnit));
    }

    public void restoreAndReplace(byte[] state) {
        Span span = this.tracingRedissonHelper.buildSpan("restoreAndReplace", this.object);
        span.setTag("state", Arrays.toString(state));
        this.tracingRedissonHelper.decorate(span, () -> this.object.restoreAndReplace(state));
    }

    public void restoreAndReplace(byte[] state, long timeToLive, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("restoreAndReplace", this.object);
        span.setTag("state", Arrays.toString(state));
        span.setTag("timeToLive", (Number)timeToLive);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        this.tracingRedissonHelper.decorate(span, () -> this.object.restoreAndReplace(state, timeToLive, timeUnit));
    }

    public byte[] dump() {
        Span span = this.tracingRedissonHelper.buildSpan("dump", this.object);
        return (byte[])this.tracingRedissonHelper.decorate(span, () -> ((RObject)this.object).dump());
    }

    public boolean touch() {
        Span span = this.tracingRedissonHelper.buildSpan("touch", this.object);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> ((RObject)this.object).touch());
    }

    public void migrate(String host, int port, int database, long timeout) {
        Span span = this.tracingRedissonHelper.buildSpan("migrate", this.object);
        span.setTag("host", TracingHelper.nullable((Object)host));
        span.setTag("port", (Number)port);
        span.setTag("database", (Number)database);
        span.setTag("timeout", (Number)timeout);
        this.tracingRedissonHelper.decorate(span, () -> this.object.migrate(host, port, database, timeout));
    }

    public void copy(String host, int port, int database, long timeout) {
        Span span = this.tracingRedissonHelper.buildSpan("copy", this.object);
        span.setTag("host", TracingHelper.nullable((Object)host));
        span.setTag("port", (Number)port);
        span.setTag("database", (Number)database);
        span.setTag("timeout", (Number)timeout);
        this.tracingRedissonHelper.decorate(span, () -> this.object.copy(host, port, database, timeout));
    }

    public boolean move(int database) {
        Span span = this.tracingRedissonHelper.buildSpan("move", this.object);
        span.setTag("database", (Number)database);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.object.move(database));
    }

    public String getName() {
        return this.object.getName();
    }

    public boolean delete() {
        Span span = this.tracingRedissonHelper.buildSpan("delete", this.object);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> ((RObject)this.object).delete());
    }

    public boolean unlink() {
        Span span = this.tracingRedissonHelper.buildSpan("unlink", this.object);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> ((RObject)this.object).unlink());
    }

    public void rename(String newName) {
        Span span = this.tracingRedissonHelper.buildSpan("rename", this.object);
        span.setTag("newName", TracingHelper.nullable((Object)newName));
        this.tracingRedissonHelper.decorate(span, () -> this.object.rename(newName));
    }

    public boolean renamenx(String newName) {
        Span span = this.tracingRedissonHelper.buildSpan("renamenx", this.object);
        span.setTag("newName", TracingHelper.nullable((Object)newName));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.object.renamenx(newName));
    }

    public boolean isExists() {
        Span span = this.tracingRedissonHelper.buildSpan("isExists", this.object);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> ((RObject)this.object).isExists());
    }

    public Codec getCodec() {
        return this.object.getCodec();
    }

    public int addListener(ObjectListener listener) {
        Span span = this.tracingRedissonHelper.buildSpan("addListener", this.object);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.object.addListener(listener));
    }

    public void removeListener(int listenerId) {
        Span span = this.tracingRedissonHelper.buildSpan("removeListener", this.object);
        span.setTag("listenerId", (Number)listenerId);
        this.tracingRedissonHelper.decorate(span, () -> this.object.removeListener(listenerId));
    }

    public RFuture<Long> sizeInMemoryAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("sizeInMemoryAsync", this.object);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RObject)this.object).sizeInMemoryAsync());
    }

    public RFuture<Void> restoreAsync(byte[] state) {
        Span span = this.tracingRedissonHelper.buildSpan("restoreAsync", this.object);
        span.setTag("state", Arrays.toString(state));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.object.restoreAsync(state));
    }

    public RFuture<Void> restoreAsync(byte[] state, long timeToLive, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("restoreAsync", this.object);
        span.setTag("state", Arrays.toString(state));
        span.setTag("timeToLive", (Number)timeToLive);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.object.restoreAsync(state, timeToLive, timeUnit));
    }

    public RFuture<Void> restoreAndReplaceAsync(byte[] state) {
        Span span = this.tracingRedissonHelper.buildSpan("restoreAndReplaceAsync", this.object);
        span.setTag("state", Arrays.toString(state));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.object.restoreAndReplaceAsync(state));
    }

    public RFuture<Void> restoreAndReplaceAsync(byte[] state, long timeToLive, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("restoreAndReplaceAsync", this.object);
        span.setTag("state", Arrays.toString(state));
        span.setTag("timeToLive", (Number)timeToLive);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.object.restoreAndReplaceAsync(state, timeToLive, timeUnit));
    }

    public RFuture<byte[]> dumpAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("dumpAsync", this.object);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RObject)this.object).dumpAsync());
    }

    public RFuture<Boolean> touchAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("touchAsync", this.object);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RObject)this.object).touchAsync());
    }

    public RFuture<Void> migrateAsync(String host, int port, int database, long timeout) {
        Span span = this.tracingRedissonHelper.buildSpan("migrateAsync", this.object);
        span.setTag("host", TracingHelper.nullable((Object)host));
        span.setTag("port", (Number)port);
        span.setTag("database", (Number)database);
        span.setTag("timeout", (Number)timeout);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.object.migrateAsync(host, port, database, timeout));
    }

    public RFuture<Void> copyAsync(String host, int port, int database, long timeout) {
        Span span = this.tracingRedissonHelper.buildSpan("copyAsync", this.object);
        span.setTag("host", TracingHelper.nullable((Object)host));
        span.setTag("port", (Number)port);
        span.setTag("database", (Number)database);
        span.setTag("timeout", (Number)timeout);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.object.copyAsync(host, port, database, timeout));
    }

    public RFuture<Boolean> moveAsync(int database) {
        Span span = this.tracingRedissonHelper.buildSpan("moveAsync", this.object);
        span.setTag("database", (Number)database);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.object.moveAsync(database));
    }

    public RFuture<Boolean> deleteAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("deleteAsync", this.object);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RObject)this.object).deleteAsync());
    }

    public RFuture<Boolean> unlinkAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("unlinkAsync", this.object);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RObject)this.object).unlinkAsync());
    }

    public RFuture<Void> renameAsync(String newName) {
        Span span = this.tracingRedissonHelper.buildSpan("renameAsync", this.object);
        span.setTag("newName", TracingHelper.nullable((Object)newName));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.object.renameAsync(newName));
    }

    public RFuture<Boolean> renamenxAsync(String newName) {
        Span span = this.tracingRedissonHelper.buildSpan("renamenxAsync", this.object);
        span.setTag("newName", TracingHelper.nullable((Object)newName));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.object.renamenxAsync(newName));
    }

    public RFuture<Boolean> isExistsAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("isExistsAsync", this.object);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RObject)this.object).isExistsAsync());
    }

    public RFuture<Integer> addListenerAsync(ObjectListener listener) {
        Span span = this.tracingRedissonHelper.buildSpan("addListenerAsync", this.object);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.object.addListenerAsync(listener));
    }

    public RFuture<Void> removeListenerAsync(int listenerId) {
        Span span = this.tracingRedissonHelper.buildSpan("removeListenerAsync", this.object);
        span.setTag("listenerId", (Number)listenerId);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.object.removeListenerAsync(listenerId));
    }

    public boolean equals(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("equals", this.object);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.object.equals(o));
    }

    public int hashCode() {
        Span span = this.tracingRedissonHelper.buildSpan("hashCode", this.object);
        return (Integer)this.tracingRedissonHelper.decorate(span, this.object::hashCode);
    }
}

