/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRExpirable;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;
import org.redisson.api.RPermitExpirableSemaphore;

public class TracingRPermitExpirableSemaphore
extends TracingRExpirable
implements RPermitExpirableSemaphore {
    private final RPermitExpirableSemaphore semaphore;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRPermitExpirableSemaphore(RPermitExpirableSemaphore semaphore, TracingRedissonHelper tracingRedissonHelper) {
        super((RExpirable)semaphore, tracingRedissonHelper);
        this.semaphore = semaphore;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public String acquire() throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("acquire", (RObject)this.semaphore);
        return (String)this.tracingRedissonHelper.decorateThrowing(span, () -> this.semaphore.acquire());
    }

    public String acquire(long leaseTime, TimeUnit unit) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("acquire", (RObject)this.semaphore);
        span.setTag("leaseTime", (Number)leaseTime);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (String)this.tracingRedissonHelper.decorateThrowing(span, () -> this.semaphore.acquire(leaseTime, unit));
    }

    public String tryAcquire() {
        Span span = this.tracingRedissonHelper.buildSpan("tryAcquire", (RObject)this.semaphore);
        return (String)this.tracingRedissonHelper.decorate(span, () -> this.semaphore.tryAcquire());
    }

    public String tryAcquire(long waitTime, TimeUnit unit) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("tryAcquire", (RObject)this.semaphore);
        span.setTag("waitTime", (Number)waitTime);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (String)this.tracingRedissonHelper.decorateThrowing(span, () -> this.semaphore.tryAcquire(waitTime, unit));
    }

    public String tryAcquire(long waitTime, long leaseTime, TimeUnit unit) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("tryAcquire", (RObject)this.semaphore);
        span.setTag("waitTime", (Number)waitTime);
        span.setTag("leaseTime", (Number)leaseTime);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (String)this.tracingRedissonHelper.decorateThrowing(span, () -> this.semaphore.tryAcquire(waitTime, leaseTime, unit));
    }

    public boolean tryRelease(String permitId) {
        Span span = this.tracingRedissonHelper.buildSpan("tryRelease", (RObject)this.semaphore);
        span.setTag("permitId", TracingHelper.nullable((Object)permitId));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.semaphore.tryRelease(permitId));
    }

    public void release(String permitId) {
        Span span = this.tracingRedissonHelper.buildSpan("release", (RObject)this.semaphore);
        span.setTag("permitId", TracingHelper.nullable((Object)permitId));
        this.tracingRedissonHelper.decorate(span, () -> this.semaphore.release(permitId));
    }

    public int availablePermits() {
        Span span = this.tracingRedissonHelper.buildSpan("availablePermits", (RObject)this.semaphore);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> ((RPermitExpirableSemaphore)this.semaphore).availablePermits());
    }

    public boolean trySetPermits(int permits) {
        Span span = this.tracingRedissonHelper.buildSpan("trySetPermits", (RObject)this.semaphore);
        span.setTag("permits", (Number)permits);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.semaphore.trySetPermits(permits));
    }

    public void addPermits(int permits) {
        Span span = this.tracingRedissonHelper.buildSpan("addPermits", (RObject)this.semaphore);
        span.setTag("permits", (Number)permits);
        this.tracingRedissonHelper.decorate(span, () -> this.semaphore.addPermits(permits));
    }

    public boolean updateLeaseTime(String permitId, long leaseTime, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("updateLeaseTime", (RObject)this.semaphore);
        span.setTag("permitId", permitId);
        span.setTag("leaseTime", (Number)leaseTime);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (Boolean)this.tracingRedissonHelper.decorateThrowing(span, () -> this.semaphore.updateLeaseTime(permitId, leaseTime, unit));
    }

    public RFuture<String> acquireAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("acquireAsync", (RObject)this.semaphore);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RPermitExpirableSemaphore)this.semaphore).acquireAsync());
    }

    public RFuture<String> acquireAsync(long leaseTime, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("acquireAsync", (RObject)this.semaphore);
        span.setTag("leaseTime", (Number)leaseTime);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.semaphore.acquireAsync(leaseTime, unit));
    }

    public RFuture<String> tryAcquireAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("tryAcquireAsync", (RObject)this.semaphore);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RPermitExpirableSemaphore)this.semaphore).tryAcquireAsync());
    }

    public RFuture<String> tryAcquireAsync(long waitTime, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("tryAcquireAsync", (RObject)this.semaphore);
        span.setTag("waitTime", (Number)waitTime);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.semaphore.tryAcquireAsync(waitTime, unit));
    }

    public RFuture<String> tryAcquireAsync(long waitTime, long leaseTime, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("tryAcquireAsync", (RObject)this.semaphore);
        span.setTag("waitTime", (Number)waitTime);
        span.setTag("leaseTime", (Number)leaseTime);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.semaphore.tryAcquireAsync(waitTime, leaseTime, unit));
    }

    public RFuture<Boolean> tryReleaseAsync(String permitId) {
        Span span = this.tracingRedissonHelper.buildSpan("tryReleaseAsync", (RObject)this.semaphore);
        span.setTag("permitId", permitId);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.semaphore.tryReleaseAsync(permitId));
    }

    public RFuture<Void> releaseAsync(String permitId) {
        Span span = this.tracingRedissonHelper.buildSpan("releaseAsync", (RObject)this.semaphore);
        span.setTag("permitId", permitId);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.semaphore.releaseAsync(permitId));
    }

    public RFuture<Integer> availablePermitsAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("availablePermitsAsync", (RObject)this.semaphore);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RPermitExpirableSemaphore)this.semaphore).availablePermitsAsync());
    }

    public RFuture<Boolean> trySetPermitsAsync(int permits) {
        Span span = this.tracingRedissonHelper.buildSpan("trySetPermitsAsync", (RObject)this.semaphore);
        span.setTag("permits", (Number)permits);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.semaphore.trySetPermitsAsync(permits));
    }

    public RFuture<Void> addPermitsAsync(int permits) {
        Span span = this.tracingRedissonHelper.buildSpan("addPermitsAsync", (RObject)this.semaphore);
        span.setTag("permits", (Number)permits);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.semaphore.addPermitsAsync(permits));
    }

    public RFuture<Boolean> updateLeaseTimeAsync(String permitId, long leaseTime, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("updateLeaseTimeAsync", (RObject)this.semaphore);
        span.setTag("permitId", permitId);
        span.setTag("leaseTime", (Number)leaseTime);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.semaphore.updateLeaseTimeAsync(permitId, leaseTime, unit));
    }
}

