/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRBlockingDeque;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Comparator;
import java.util.stream.Stream;
import org.redisson.api.RObject;
import org.redisson.api.RPriorityBlockingDeque;

public class TracingRPriorityBlockingDeque<V>
extends TracingRBlockingDeque<V>
implements RPriorityBlockingDeque<V> {
    private final RPriorityBlockingDeque<V> deque;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRPriorityBlockingDeque(RPriorityBlockingDeque<V> deque, TracingRedissonHelper tracingRedissonHelper) {
        super(deque, tracingRedissonHelper);
        this.deque = deque;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public Comparator<? super V> comparator() {
        return this.deque.comparator();
    }

    public boolean trySetComparator(Comparator<? super V> comparator) {
        Span span = this.tracingRedissonHelper.buildSpan("trySetComparator", (RObject)this.deque);
        span.setTag("comparator", TracingHelper.nullable(comparator));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.deque.trySetComparator(comparator));
    }

    public Stream<V> descendingStream() {
        Span span = this.tracingRedissonHelper.buildSpan("descendingStream", (RObject)this.deque);
        return (Stream)this.tracingRedissonHelper.decorate(span, () -> this.deque.descendingStream());
    }
}

