/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRBlockingQueue;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Comparator;
import org.redisson.api.RObject;
import org.redisson.api.RPriorityBlockingQueue;

public class TracingRPriorityBlockingQueue<V>
extends TracingRBlockingQueue<V>
implements RPriorityBlockingQueue<V> {
    private final RPriorityBlockingQueue<V> queue;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRPriorityBlockingQueue(RPriorityBlockingQueue<V> queue, TracingRedissonHelper tracingRedissonHelper) {
        super(queue, tracingRedissonHelper);
        this.queue = queue;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public Comparator<? super V> comparator() {
        return this.queue.comparator();
    }

    public boolean trySetComparator(Comparator<? super V> comparator) {
        Span span = this.tracingRedissonHelper.buildSpan("trySetComparator", (RObject)this.queue);
        span.setTag("comparator", TracingHelper.nullable(comparator));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.trySetComparator(comparator));
    }
}

