/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRObject;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.redisson.api.RObject;
import org.redisson.api.RPriorityQueue;

public class TracingRPriorityQueue<V>
extends TracingRObject
implements RPriorityQueue<V> {
    private final RPriorityQueue<V> queue;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRPriorityQueue(RPriorityQueue<V> queue, TracingRedissonHelper tracingRedissonHelper) {
        super((RObject)queue, tracingRedissonHelper);
        this.queue = queue;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public Comparator<? super V> comparator() {
        return this.queue.comparator();
    }

    public List<V> readAll() {
        Span span = this.tracingRedissonHelper.buildSpan("readAll", (RObject)this.queue);
        return (List)this.tracingRedissonHelper.decorate(span, () -> this.queue.readAll());
    }

    public V pollLastAndOfferFirstTo(String dequeName) {
        Span span = this.tracingRedissonHelper.buildSpan("pollLastAndOfferFirstTo", (RObject)this.queue);
        span.setTag("dequeName", TracingHelper.nullable((Object)dequeName));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.queue.pollLastAndOfferFirstTo(dequeName));
    }

    public boolean trySetComparator(Comparator<? super V> comparator) {
        Span span = this.tracingRedissonHelper.buildSpan("trySetComparator", (RObject)this.queue);
        span.setTag("comparator", TracingHelper.nullable(comparator));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.trySetComparator(comparator));
    }

    public boolean add(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("add", (RObject)this.queue);
        span.setTag("element", TracingHelper.nullable(v));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.add(v));
    }

    public boolean offer(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("offer", (RObject)this.queue);
        span.setTag("element", TracingHelper.nullable(v));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.offer(v));
    }

    public V remove() {
        Span span = this.tracingRedissonHelper.buildSpan("remove", (RObject)this.queue);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.queue.remove());
    }

    public V poll() {
        Span span = this.tracingRedissonHelper.buildSpan("poll", (RObject)this.queue);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.queue.poll());
    }

    public V element() {
        Span span = this.tracingRedissonHelper.buildSpan("element", (RObject)this.queue);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.queue.element());
    }

    public V peek() {
        Span span = this.tracingRedissonHelper.buildSpan("peek", (RObject)this.queue);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.queue.peek());
    }

    public int size() {
        Span span = this.tracingRedissonHelper.buildSpan("size", (RObject)this.queue);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.queue.size());
    }

    public boolean isEmpty() {
        Span span = this.tracingRedissonHelper.buildSpan("isEmpty", (RObject)this.queue);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.isEmpty());
    }

    public boolean contains(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("contains", (RObject)this.queue);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.contains(o));
    }

    public Iterator<V> iterator() {
        return this.queue.iterator();
    }

    public Object[] toArray() {
        Span span = this.tracingRedissonHelper.buildSpan("toArray", (RObject)this.queue);
        return (Object[])this.tracingRedissonHelper.decorate(span, () -> this.queue.toArray());
    }

    public <T> T[] toArray(T[] a) {
        Span span = this.tracingRedissonHelper.buildSpan("toArray", (RObject)this.queue);
        return (Object[])this.tracingRedissonHelper.decorate(span, () -> this.queue.toArray(a));
    }

    public boolean remove(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("remove", (RObject)this.queue);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.remove(o));
    }

    public boolean containsAll(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("containsAll", (RObject)this.queue);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.containsAll(c));
    }

    public boolean addAll(Collection<? extends V> c) {
        Span span = this.tracingRedissonHelper.buildSpan("addAll", (RObject)this.queue);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.addAll(c));
    }

    public boolean removeAll(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAll", (RObject)this.queue);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.removeAll(c));
    }

    public boolean removeIf(Predicate<? super V> filter) {
        Span span = this.tracingRedissonHelper.buildSpan("removeIf", (RObject)this.queue);
        span.setTag("filter", TracingHelper.nullable(filter));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.removeIf(filter));
    }

    public boolean retainAll(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("retainAll", (RObject)this.queue);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.retainAll(c));
    }

    public void clear() {
        Span span = this.tracingRedissonHelper.buildSpan("clear", (RObject)this.queue);
        this.tracingRedissonHelper.decorate(span, () -> this.queue.clear());
    }

    public Spliterator<V> spliterator() {
        return this.queue.spliterator();
    }

    public Stream<V> stream() {
        return this.queue.stream();
    }

    public Stream<V> parallelStream() {
        return this.queue.parallelStream();
    }

    public void forEach(Consumer<? super V> action) {
        Span span = this.tracingRedissonHelper.buildSpan("forEach", (RObject)this.queue);
        span.setTag("action", TracingHelper.nullable(action));
        this.tracingRedissonHelper.decorate(span, () -> this.queue.forEach(action));
    }
}

