/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRExpirable;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.redisson.api.RExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;
import org.redisson.api.RQueue;

public class TracingRQueue<V>
extends TracingRExpirable
implements RQueue<V> {
    private final RQueue<V> queue;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRQueue(RQueue<V> queue, TracingRedissonHelper tracingRedissonHelper) {
        super((RExpirable)queue, tracingRedissonHelper);
        this.queue = queue;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public V pollLastAndOfferFirstTo(String dequeName) {
        Span span = this.tracingRedissonHelper.buildSpan("pollLastAndOfferFirstTo", (RObject)this.queue);
        span.setTag("dequeName", TracingHelper.nullable((Object)dequeName));
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.queue.pollLastAndOfferFirstTo(dequeName));
    }

    public List<V> readAll() {
        Span span = this.tracingRedissonHelper.buildSpan("readAll", (RObject)this.queue);
        return (List)this.tracingRedissonHelper.decorate(span, () -> this.queue.readAll());
    }

    public boolean add(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("add", (RObject)this.queue);
        span.setTag("element", TracingHelper.nullable(v));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.add(v));
    }

    public boolean offer(V v) {
        Span span = this.tracingRedissonHelper.buildSpan("offer", (RObject)this.queue);
        span.setTag("element", TracingHelper.nullable(v));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.offer(v));
    }

    public V remove() {
        Span span = this.tracingRedissonHelper.buildSpan("remove", (RObject)this.queue);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.queue.remove());
    }

    public V poll() {
        Span span = this.tracingRedissonHelper.buildSpan("poll", (RObject)this.queue);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.queue.poll());
    }

    public V element() {
        Span span = this.tracingRedissonHelper.buildSpan("element", (RObject)this.queue);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.queue.element());
    }

    public V peek() {
        Span span = this.tracingRedissonHelper.buildSpan("peek", (RObject)this.queue);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.queue.peek());
    }

    public int size() {
        Span span = this.tracingRedissonHelper.buildSpan("size", (RObject)this.queue);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.queue.size());
    }

    public boolean isEmpty() {
        Span span = this.tracingRedissonHelper.buildSpan("isEmpty", (RObject)this.queue);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.isEmpty());
    }

    public boolean contains(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("contains", (RObject)this.queue);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.contains(o));
    }

    public Iterator<V> iterator() {
        return this.queue.iterator();
    }

    public Object[] toArray() {
        Span span = this.tracingRedissonHelper.buildSpan("toArray", (RObject)this.queue);
        return (Object[])this.tracingRedissonHelper.decorate(span, () -> this.queue.toArray());
    }

    public <T> T[] toArray(T[] a) {
        Span span = this.tracingRedissonHelper.buildSpan("toArray", (RObject)this.queue);
        return (Object[])this.tracingRedissonHelper.decorate(span, () -> this.queue.toArray(a));
    }

    public boolean remove(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("remove", (RObject)this.queue);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.remove(o));
    }

    public boolean containsAll(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("containsAll", (RObject)this.queue);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.containsAll(c));
    }

    public boolean addAll(Collection<? extends V> c) {
        Span span = this.tracingRedissonHelper.buildSpan("addAll", (RObject)this.queue);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.addAll(c));
    }

    public boolean removeAll(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAll", (RObject)this.queue);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.removeAll(c));
    }

    public boolean removeIf(Predicate<? super V> filter) {
        Span span = this.tracingRedissonHelper.buildSpan("removeIf", (RObject)this.queue);
        span.setTag("filter", TracingHelper.nullable(filter));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.removeIf(filter));
    }

    public boolean retainAll(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("retainAll", (RObject)this.queue);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.queue.retainAll(c));
    }

    public void clear() {
        Span span = this.tracingRedissonHelper.buildSpan("clear", (RObject)this.queue);
        this.tracingRedissonHelper.decorate(span, () -> this.queue.clear());
    }

    public Spliterator<V> spliterator() {
        return this.queue.spliterator();
    }

    public Stream<V> stream() {
        return this.queue.stream();
    }

    public Stream<V> parallelStream() {
        return this.queue.parallelStream();
    }

    public void forEach(Consumer<? super V> action) {
        Span span = this.tracingRedissonHelper.buildSpan("forEach", (RObject)this.queue);
        span.setTag("action", TracingHelper.nullable(action));
        this.tracingRedissonHelper.decorate(span, () -> this.queue.forEach(action));
    }

    public RFuture<V> peekAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("peekAsync", (RObject)this.queue);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.peekAsync());
    }

    public RFuture<V> pollAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("pollAsync", (RObject)this.queue);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.pollAsync());
    }

    public RFuture<Boolean> offerAsync(V e) {
        Span span = this.tracingRedissonHelper.buildSpan("offerAsync", (RObject)this.queue);
        span.setTag("element", TracingHelper.nullable(e));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.offerAsync(e));
    }

    public RFuture<V> pollLastAndOfferFirstToAsync(String queueName) {
        Span span = this.tracingRedissonHelper.buildSpan("pollLastAndOfferFirstToAsync", (RObject)this.queue);
        span.setTag("queueName", TracingHelper.nullable((Object)queueName));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.pollLastAndOfferFirstToAsync(queueName));
    }

    public RFuture<List<V>> readAllAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("readAllAsync", (RObject)this.queue);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.readAllAsync());
    }

    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("retainAllAsync", (RObject)this.queue);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.retainAllAsync(c));
    }

    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAllAsync", (RObject)this.queue);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.removeAllAsync(c));
    }

    public RFuture<Boolean> containsAsync(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("containsAsync", (RObject)this.queue);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.containsAsync(o));
    }

    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("containsAllAsync", (RObject)this.queue);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.containsAllAsync(c));
    }

    public RFuture<Boolean> removeAsync(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAsync", (RObject)this.queue);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.removeAsync(o));
    }

    public RFuture<Integer> sizeAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("sizeAsync", (RObject)this.queue);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.sizeAsync());
    }

    public RFuture<Boolean> addAsync(V e) {
        Span span = this.tracingRedissonHelper.buildSpan("addAsync", (RObject)this.queue);
        span.setTag("element", TracingHelper.nullable(e));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.addAsync(e));
    }

    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        Span span = this.tracingRedissonHelper.buildSpan("addAllAsync", (RObject)this.queue);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.queue.addAllAsync(c));
    }
}

