/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRExpirable;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;
import org.redisson.api.RSemaphore;

public class TracingRSemaphore
extends TracingRExpirable
implements RSemaphore {
    private final RSemaphore semaphore;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRSemaphore(RSemaphore semaphore, TracingRedissonHelper tracingRedissonHelper) {
        super((RExpirable)semaphore, tracingRedissonHelper);
        this.semaphore = semaphore;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public void acquire() throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("acquire", (RObject)this.semaphore);
        this.tracingRedissonHelper.decorateThrowing(span, () -> this.semaphore.acquire());
    }

    public void acquire(int permits) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("acquire", (RObject)this.semaphore);
        span.setTag("permits", (Number)permits);
        this.tracingRedissonHelper.decorateThrowing(span, () -> this.semaphore.acquire(permits));
    }

    public boolean tryAcquire() {
        Span span = this.tracingRedissonHelper.buildSpan("tryAcquire", (RObject)this.semaphore);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.semaphore.tryAcquire());
    }

    public boolean tryAcquire(int permits) {
        Span span = this.tracingRedissonHelper.buildSpan("tryAcquire", (RObject)this.semaphore);
        span.setTag("permits", (Number)permits);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.semaphore.tryAcquire(permits));
    }

    public boolean tryAcquire(long waitTime, TimeUnit unit) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("tryAcquire", (RObject)this.semaphore);
        span.setTag("waitTime", (Number)waitTime);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (Boolean)this.tracingRedissonHelper.decorateThrowing(span, () -> this.semaphore.tryAcquire(waitTime, unit));
    }

    public boolean tryAcquire(int permits, long waitTime, TimeUnit unit) throws InterruptedException {
        Span span = this.tracingRedissonHelper.buildSpan("tryAcquire", (RObject)this.semaphore);
        span.setTag("permits", (Number)permits);
        span.setTag("waitTime", (Number)waitTime);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (Boolean)this.tracingRedissonHelper.decorateThrowing(span, () -> this.semaphore.tryAcquire(permits, waitTime, unit));
    }

    public void release() {
        Span span = this.tracingRedissonHelper.buildSpan("release", (RObject)this.semaphore);
        this.tracingRedissonHelper.decorate(span, () -> this.semaphore.release());
    }

    public void release(int permits) {
        Span span = this.tracingRedissonHelper.buildSpan("release", (RObject)this.semaphore);
        span.setTag("permits", (Number)permits);
        this.tracingRedissonHelper.decorate(span, () -> this.semaphore.release(permits));
    }

    public int availablePermits() {
        Span span = this.tracingRedissonHelper.buildSpan("availablePermits", (RObject)this.semaphore);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> ((RSemaphore)this.semaphore).availablePermits());
    }

    public int drainPermits() {
        Span span = this.tracingRedissonHelper.buildSpan("drainPermits", (RObject)this.semaphore);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> ((RSemaphore)this.semaphore).drainPermits());
    }

    public boolean trySetPermits(int permits) {
        Span span = this.tracingRedissonHelper.buildSpan("trySetPermits", (RObject)this.semaphore);
        span.setTag("permits", (Number)permits);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.semaphore.trySetPermits(permits));
    }

    public void reducePermits(int permits) {
        Span span = this.tracingRedissonHelper.buildSpan("reducePermits", (RObject)this.semaphore);
        span.setTag("permits", (Number)permits);
        this.tracingRedissonHelper.decorate(span, () -> this.semaphore.reducePermits(permits));
    }

    public RFuture<Boolean> tryAcquireAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("tryAcquireAsync", (RObject)this.semaphore);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RSemaphore)this.semaphore).tryAcquireAsync());
    }

    public RFuture<Boolean> tryAcquireAsync(int permits) {
        Span span = this.tracingRedissonHelper.buildSpan("tryAcquireAsync", (RObject)this.semaphore);
        span.setTag("permits", (Number)permits);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.semaphore.tryAcquireAsync(permits));
    }

    public RFuture<Void> acquireAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("acquireAsync", (RObject)this.semaphore);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RSemaphore)this.semaphore).acquireAsync());
    }

    public RFuture<Void> acquireAsync(int permits) {
        Span span = this.tracingRedissonHelper.buildSpan("acquireAsync", (RObject)this.semaphore);
        span.setTag("permits", (Number)permits);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.semaphore.acquireAsync(permits));
    }

    public RFuture<Void> releaseAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("releaseAsync", (RObject)this.semaphore);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> ((RSemaphore)this.semaphore).releaseAsync());
    }

    public RFuture<Void> releaseAsync(int permits) {
        Span span = this.tracingRedissonHelper.buildSpan("releaseAsync", (RObject)this.semaphore);
        span.setTag("permits", (Number)permits);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.semaphore.releaseAsync(permits));
    }

    public RFuture<Boolean> trySetPermitsAsync(int permits) {
        Span span = this.tracingRedissonHelper.buildSpan("trySetPermitsAsync", (RObject)this.semaphore);
        span.setTag("permits", (Number)permits);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.semaphore.trySetPermitsAsync(permits));
    }

    public RFuture<Boolean> tryAcquireAsync(long waitTime, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("tryAcquireAsync", (RObject)this.semaphore);
        span.setTag("waitTime", (Number)waitTime);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.semaphore.tryAcquireAsync(waitTime, unit));
    }

    public RFuture<Boolean> tryAcquireAsync(int permits, long waitTime, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("tryAcquireAsync", (RObject)this.semaphore);
        span.setTag("permits", (Number)permits);
        span.setTag("waitTime", (Number)waitTime);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.semaphore.tryAcquireAsync(permits, waitTime, unit));
    }

    public RFuture<Void> reducePermitsAsync(int permits) {
        Span span = this.tracingRedissonHelper.buildSpan("reducePermitsAsync", (RObject)this.semaphore);
        span.setTag("permits", (Number)permits);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.semaphore.reducePermitsAsync(permits));
    }
}

