/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRCollectionMapReduce;
import io.opentracing.contrib.redis.redisson.TracingRCountDownLatch;
import io.opentracing.contrib.redis.redisson.TracingRExpirable;
import io.opentracing.contrib.redis.redisson.TracingRLock;
import io.opentracing.contrib.redis.redisson.TracingRPermitExpirableSemaphore;
import io.opentracing.contrib.redis.redisson.TracingRReadWriteLock;
import io.opentracing.contrib.redis.redisson.TracingRSemaphore;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.Spliterator;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.redisson.api.RCountDownLatch;
import org.redisson.api.RExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RObject;
import org.redisson.api.RPermitExpirableSemaphore;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RSemaphore;
import org.redisson.api.RSet;
import org.redisson.api.SortOrder;
import org.redisson.api.mapreduce.RCollectionMapReduce;

public class TracingRSet<V>
extends TracingRExpirable
implements RSet<V> {
    private final RSet<V> set;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRSet(RSet<V> set, TracingRedissonHelper tracingRedissonHelper) {
        super((RExpirable)set, tracingRedissonHelper);
        this.set = set;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public RCountDownLatch getCountDownLatch(V value) {
        return new TracingRCountDownLatch(this.set.getCountDownLatch(value), this.tracingRedissonHelper);
    }

    public RPermitExpirableSemaphore getPermitExpirableSemaphore(V value) {
        return new TracingRPermitExpirableSemaphore(this.set.getPermitExpirableSemaphore(value), this.tracingRedissonHelper);
    }

    public RSemaphore getSemaphore(V value) {
        return new TracingRSemaphore(this.set.getSemaphore(value), this.tracingRedissonHelper);
    }

    public RLock getFairLock(V value) {
        return new TracingRLock(this.set.getFairLock(value), this.tracingRedissonHelper);
    }

    public RReadWriteLock getReadWriteLock(V value) {
        return new TracingRReadWriteLock(this.set.getReadWriteLock(value), this.tracingRedissonHelper);
    }

    public RLock getLock(V value) {
        return new TracingRLock(this.set.getLock(value), this.tracingRedissonHelper);
    }

    public Stream<V> stream(int count) {
        Span span = this.tracingRedissonHelper.buildSpan("stream", (RObject)this.set);
        span.setTag("count", (Number)count);
        return (Stream)this.tracingRedissonHelper.decorate(span, () -> this.set.stream(count));
    }

    public Stream<V> stream(String pattern, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("stream", (RObject)this.set);
        span.setTag("pattern", TracingHelper.nullable((Object)pattern));
        span.setTag("count", (Number)count);
        return (Stream)this.tracingRedissonHelper.decorate(span, () -> this.set.stream(pattern, count));
    }

    public Stream<V> stream(String pattern) {
        Span span = this.tracingRedissonHelper.buildSpan("stream", (RObject)this.set);
        span.setTag("pattern", TracingHelper.nullable((Object)pattern));
        return (Stream)this.tracingRedissonHelper.decorate(span, () -> this.set.stream(pattern));
    }

    public Iterator<V> iterator(int count) {
        return this.set.iterator(count);
    }

    public Iterator<V> iterator(String pattern, int count) {
        return this.set.iterator(pattern, count);
    }

    public Iterator<V> iterator(String pattern) {
        return this.set.iterator(pattern);
    }

    public <KOut, VOut> RCollectionMapReduce<V, KOut, VOut> mapReduce() {
        return new TracingRCollectionMapReduce(this.set.mapReduce(), this.tracingRedissonHelper);
    }

    public Set<V> removeRandom(int amount) {
        Span span = this.tracingRedissonHelper.buildSpan("removeRandom", (RObject)this.set);
        span.setTag("amount", (Number)amount);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.set.removeRandom(amount));
    }

    public V removeRandom() {
        Span span = this.tracingRedissonHelper.buildSpan("removeRandom", (RObject)this.set);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.set.removeRandom());
    }

    public V random() {
        Span span = this.tracingRedissonHelper.buildSpan("random", (RObject)this.set);
        return (V)this.tracingRedissonHelper.decorate(span, () -> this.set.random());
    }

    public Set<V> random(int count) {
        Span span = this.tracingRedissonHelper.buildSpan("random", (RObject)this.set);
        span.setTag("count", (Number)count);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.set.random(count));
    }

    public boolean move(String destination, V member) {
        Span span = this.tracingRedissonHelper.buildSpan("move", (RObject)this.set);
        span.setTag("destination", TracingHelper.nullable((Object)destination));
        span.setTag("member", TracingHelper.nullable(member));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.move(destination, member));
    }

    public Set<V> readAll() {
        Span span = this.tracingRedissonHelper.buildSpan("readAll", (RObject)this.set);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.set.readAll());
    }

    public int union(String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("union", (RObject)this.set);
        span.setTag("names", Arrays.toString(names));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.union(names));
    }

    public Set<V> readUnion(String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("readUnion", (RObject)this.set);
        span.setTag("names", Arrays.toString(names));
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.set.readUnion(names));
    }

    public int diff(String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("diff", (RObject)this.set);
        span.setTag("names", Arrays.toString(names));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.diff(names));
    }

    public Set<V> readDiff(String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("readDiff", (RObject)this.set);
        span.setTag("names", Arrays.toString(names));
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.set.readDiff(names));
    }

    public int intersection(String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("intersection", (RObject)this.set);
        span.setTag("names", Arrays.toString(names));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.intersection(names));
    }

    public Set<V> readIntersection(String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("readIntersection", (RObject)this.set);
        span.setTag("names", Arrays.toString(names));
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.set.readIntersection(names));
    }

    public int size() {
        Span span = this.tracingRedissonHelper.buildSpan("size", (RObject)this.set);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.size());
    }

    public boolean isEmpty() {
        Span span = this.tracingRedissonHelper.buildSpan("isEmpty", (RObject)this.set);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.isEmpty());
    }

    public boolean contains(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("contains", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.contains(o));
    }

    public Iterator<V> iterator() {
        return this.set.iterator();
    }

    public Object[] toArray() {
        Span span = this.tracingRedissonHelper.buildSpan("toArray", (RObject)this.set);
        return (Object[])this.tracingRedissonHelper.decorate(span, () -> this.set.toArray());
    }

    public <T> T[] toArray(T[] a) {
        Span span = this.tracingRedissonHelper.buildSpan("toArray", (RObject)this.set);
        return (Object[])this.tracingRedissonHelper.decorate(span, () -> this.set.toArray(a));
    }

    public boolean add(V element) {
        Span span = this.tracingRedissonHelper.buildSpan("add", (RObject)this.set);
        span.setTag("element", TracingHelper.nullable(element));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.add(element));
    }

    public boolean remove(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("remove", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.remove(o));
    }

    public boolean containsAll(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("containsAll", (RObject)this.set);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.containsAll(c));
    }

    public boolean addAll(Collection<? extends V> c) {
        Span span = this.tracingRedissonHelper.buildSpan("addAll", (RObject)this.set);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.addAll(c));
    }

    public boolean retainAll(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("retainAll", (RObject)this.set);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.retainAll(c));
    }

    public boolean removeAll(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAll", (RObject)this.set);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.removeAll(c));
    }

    public void clear() {
        Span span = this.tracingRedissonHelper.buildSpan("clear", (RObject)this.set);
        this.tracingRedissonHelper.decorate(span, () -> this.set.clear());
    }

    public Spliterator<V> spliterator() {
        return this.set.spliterator();
    }

    public boolean removeIf(Predicate<? super V> filter) {
        Span span = this.tracingRedissonHelper.buildSpan("removeIf", (RObject)this.set);
        span.setTag("filter", TracingHelper.nullable(filter));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.set.removeIf(filter));
    }

    public Stream<V> stream() {
        return this.set.stream();
    }

    public Stream<V> parallelStream() {
        return this.set.parallelStream();
    }

    public void forEach(Consumer<? super V> action) {
        Span span = this.tracingRedissonHelper.buildSpan("forEach", (RObject)this.set);
        span.setTag("action", TracingHelper.nullable(action));
        this.tracingRedissonHelper.decorate(span, () -> this.set.forEach(action));
    }

    public RFuture<Set<V>> removeRandomAsync(int amount) {
        Span span = this.tracingRedissonHelper.buildSpan("removeRandomAsync", (RObject)this.set);
        span.setTag("amount", (Number)amount);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.removeRandomAsync(amount));
    }

    public RFuture<V> removeRandomAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("removeRandomAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.removeRandomAsync());
    }

    public RFuture<V> randomAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("randomAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.randomAsync());
    }

    public RFuture<Set<V>> randomAsync(int count) {
        Span span = this.tracingRedissonHelper.buildSpan("randomAsync", (RObject)this.set);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.randomAsync(count));
    }

    public RFuture<Boolean> moveAsync(String destination, V member) {
        Span span = this.tracingRedissonHelper.buildSpan("moveAsync", (RObject)this.set);
        span.setTag("destination", TracingHelper.nullable((Object)destination));
        span.setTag("member", TracingHelper.nullable(member));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.moveAsync(destination, member));
    }

    public RFuture<Set<V>> readAllAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("readAllAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readAllAsync());
    }

    public RFuture<Integer> unionAsync(String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("unionAsync", (RObject)this.set);
        span.setTag("names", Arrays.toString(names));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.unionAsync(names));
    }

    public RFuture<Set<V>> readUnionAsync(String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("readUnionAsync", (RObject)this.set);
        span.setTag("names", Arrays.toString(names));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readUnionAsync(names));
    }

    public RFuture<Integer> diffAsync(String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("diffAsync", (RObject)this.set);
        span.setTag("names", Arrays.toString(names));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.diffAsync(names));
    }

    public RFuture<Set<V>> readDiffAsync(String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("readDiffAsync", (RObject)this.set);
        span.setTag("names", Arrays.toString(names));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readDiffAsync(names));
    }

    public RFuture<Integer> intersectionAsync(String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("intersectionAsync", (RObject)this.set);
        span.setTag("names", Arrays.toString(names));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.intersectionAsync(names));
    }

    public RFuture<Set<V>> readIntersectionAsync(String ... names) {
        Span span = this.tracingRedissonHelper.buildSpan("readIntersectionAsync", (RObject)this.set);
        span.setTag("names", Arrays.toString(names));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readIntersectionAsync(names));
    }

    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("retainAllAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.retainAllAsync(c));
    }

    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAllAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.removeAllAsync(c));
    }

    public RFuture<Boolean> containsAsync(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("containsAsync", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.containsAsync(o));
    }

    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("containsAllAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.containsAllAsync(c));
    }

    public RFuture<Boolean> removeAsync(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAsync", (RObject)this.set);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.removeAsync(o));
    }

    public RFuture<Integer> sizeAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("sizeAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.sizeAsync());
    }

    public RFuture<Boolean> addAsync(V e) {
        Span span = this.tracingRedissonHelper.buildSpan("addAsync", (RObject)this.set);
        span.setTag("element", TracingHelper.nullable(e));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.addAsync(e));
    }

    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        Span span = this.tracingRedissonHelper.buildSpan("addAllAsync", (RObject)this.set);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.addAllAsync(c));
    }

    public RFuture<Set<V>> readSortAsync(SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAsync", (RObject)this.set);
        span.setTag("order", TracingHelper.nullable((Object)order));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAsync(order));
    }

    public RFuture<Set<V>> readSortAsync(SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAsync", (RObject)this.set);
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAsync(order, offset, count));
    }

    public RFuture<Set<V>> readSortAsync(String byPattern, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAsync", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAsync(byPattern, order));
    }

    public RFuture<Set<V>> readSortAsync(String byPattern, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAsync", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAsync(byPattern, order, offset, count));
    }

    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAsync", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAsync(byPattern, getPatterns, order));
    }

    public <T> RFuture<Collection<T>> readSortAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAsync", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAsync(byPattern, getPatterns, order, offset, count));
    }

    public RFuture<Set<V>> readSortAlphaAsync(SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlphaAsync", (RObject)this.set);
        span.setTag("order", TracingHelper.nullable((Object)order));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAlphaAsync(order));
    }

    public RFuture<Set<V>> readSortAlphaAsync(SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlphaAsync", (RObject)this.set);
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAlphaAsync(order, offset, count));
    }

    public RFuture<Set<V>> readSortAlphaAsync(String byPattern, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlphaAsync", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAlphaAsync(byPattern, order));
    }

    public RFuture<Set<V>> readSortAlphaAsync(String byPattern, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlphaAsync", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAlphaAsync(byPattern, order, offset, count));
    }

    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlphaAsync", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAlphaAsync(byPattern, getPatterns, order));
    }

    public <T> RFuture<Collection<T>> readSortAlphaAsync(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlphaAsync", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.readSortAlphaAsync(byPattern, getPatterns, order, offset, count));
    }

    public RFuture<Integer> sortToAsync(String destName, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("sortToAsync", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.sortToAsync(destName, order));
    }

    public RFuture<Integer> sortToAsync(String destName, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("sortToAsync", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.sortToAsync(destName, order, offset, count));
    }

    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("sortToAsync", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.sortToAsync(destName, byPattern, order));
    }

    public RFuture<Integer> sortToAsync(String destName, String byPattern, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("sortToAsync", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.sortToAsync(destName, byPattern, order, offset, count));
    }

    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("sortToAsync", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.sortToAsync(destName, byPattern, getPatterns, order));
    }

    public RFuture<Integer> sortToAsync(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("sortToAsync", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.set.sortToAsync(destName, byPattern, getPatterns, order, offset, count));
    }

    public Set<V> readSort(SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSort", (RObject)this.set);
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (Set)this.tracingRedissonHelper.decorate(span, () -> (Set)this.set.readSort(order));
    }

    public Set<V> readSort(SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSort", (RObject)this.set);
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> (Set)this.set.readSort(order, offset, count));
    }

    public Set<V> readSort(String byPattern, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSort", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (Set)this.tracingRedissonHelper.decorate(span, () -> (Set)this.set.readSort(byPattern, order));
    }

    public Set<V> readSort(String byPattern, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSort", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> (Set)this.set.readSort(byPattern, order, offset, count));
    }

    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSort", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.readSort(byPattern, getPatterns, order));
    }

    public <T> Collection<T> readSort(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSort", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.readSort(byPattern, getPatterns, order, offset, count));
    }

    public Set<V> readSortAlpha(SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlpha", (RObject)this.set);
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (Set)this.tracingRedissonHelper.decorate(span, () -> (Set)this.set.readSortAlpha(order));
    }

    public Set<V> readSortAlpha(SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlpha", (RObject)this.set);
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> (Set)this.set.readSortAlpha(order, offset, count));
    }

    public Set<V> readSortAlpha(String byPattern, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlpha", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (Set)this.tracingRedissonHelper.decorate(span, () -> (Set)this.set.readSortAlpha(byPattern, order));
    }

    public Set<V> readSortAlpha(String byPattern, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlpha", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> (Set)this.set.readSortAlpha(byPattern, order, offset, count));
    }

    public <T> Collection<T> readSortAlpha(String byPattern, List<String> getPatterns, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlpha", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.readSortAlpha(byPattern, getPatterns, order));
    }

    public <T> Collection<T> readSortAlpha(String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("readSortAlpha", (RObject)this.set);
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Collection)this.tracingRedissonHelper.decorate(span, () -> this.set.readSortAlpha(byPattern, getPatterns, order, offset, count));
    }

    public int sortTo(String destName, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("sortTo", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.sortTo(destName, order));
    }

    public int sortTo(String destName, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("sortTo", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.sortTo(destName, order, offset, count));
    }

    public int sortTo(String destName, String byPattern, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("sortTo", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.sortTo(destName, byPattern, order));
    }

    public int sortTo(String destName, String byPattern, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("sortTo", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.sortTo(destName, byPattern, order, offset, count));
    }

    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order) {
        Span span = this.tracingRedissonHelper.buildSpan("sortTo", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("order", TracingHelper.nullable((Object)order));
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.sortTo(destName, byPattern, getPatterns, order));
    }

    public int sortTo(String destName, String byPattern, List<String> getPatterns, SortOrder order, int offset, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("sortTo", (RObject)this.set);
        span.setTag("destName", TracingHelper.nullable((Object)destName));
        span.setTag("byPattern", TracingHelper.nullable((Object)byPattern));
        span.setTag("getPatterns", TracingHelper.collectionToString(getPatterns));
        span.setTag("order", TracingHelper.nullable((Object)order));
        span.setTag("offset", (Number)offset);
        span.setTag("count", (Number)count);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.set.sortTo(destName, byPattern, getPatterns, order, offset, count));
    }
}

