/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRCollectionMapReduce;
import io.opentracing.contrib.redis.redisson.TracingRCountDownLatch;
import io.opentracing.contrib.redis.redisson.TracingRExpirable;
import io.opentracing.contrib.redis.redisson.TracingRLock;
import io.opentracing.contrib.redis.redisson.TracingRPermitExpirableSemaphore;
import io.opentracing.contrib.redis.redisson.TracingRReadWriteLock;
import io.opentracing.contrib.redis.redisson.TracingRSemaphore;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.Collection;
import java.util.Iterator;
import java.util.Set;
import java.util.Spliterator;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.redisson.api.RCountDownLatch;
import org.redisson.api.RExpirable;
import org.redisson.api.RFuture;
import org.redisson.api.RLock;
import org.redisson.api.RObject;
import org.redisson.api.RPermitExpirableSemaphore;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RSemaphore;
import org.redisson.api.RSetCache;
import org.redisson.api.mapreduce.RCollectionMapReduce;

public class TracingRSetCache<V>
extends TracingRExpirable
implements RSetCache<V> {
    private final RSetCache<V> cache;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRSetCache(RSetCache<V> cache, TracingRedissonHelper tracingRedissonHelper) {
        super((RExpirable)cache, tracingRedissonHelper);
        this.cache = cache;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public RCountDownLatch getCountDownLatch(V value) {
        return new TracingRCountDownLatch(this.cache.getCountDownLatch(value), this.tracingRedissonHelper);
    }

    public RPermitExpirableSemaphore getPermitExpirableSemaphore(V value) {
        return new TracingRPermitExpirableSemaphore(this.cache.getPermitExpirableSemaphore(value), this.tracingRedissonHelper);
    }

    public RSemaphore getSemaphore(V value) {
        return new TracingRSemaphore(this.cache.getSemaphore(value), this.tracingRedissonHelper);
    }

    public RLock getFairLock(V value) {
        return new TracingRLock(this.cache.getFairLock(value), this.tracingRedissonHelper);
    }

    public RReadWriteLock getReadWriteLock(V value) {
        return new TracingRReadWriteLock(this.cache.getReadWriteLock(value), this.tracingRedissonHelper);
    }

    public RLock getLock(V value) {
        return new TracingRLock(this.cache.getLock(value), this.tracingRedissonHelper);
    }

    public Stream<V> stream(int count) {
        Span span = this.tracingRedissonHelper.buildSpan("stream", (RObject)this.cache);
        span.setTag("count", (Number)count);
        return (Stream)this.tracingRedissonHelper.decorate(span, () -> this.cache.stream(count));
    }

    public Stream<V> stream(String pattern, int count) {
        Span span = this.tracingRedissonHelper.buildSpan("stream", (RObject)this.cache);
        span.setTag("pattern", TracingHelper.nullable((Object)pattern));
        span.setTag("count", (Number)count);
        return (Stream)this.tracingRedissonHelper.decorate(span, () -> this.cache.stream(pattern, count));
    }

    public Stream<V> stream(String pattern) {
        Span span = this.tracingRedissonHelper.buildSpan("stream", (RObject)this.cache);
        span.setTag("pattern", TracingHelper.nullable((Object)pattern));
        return (Stream)this.tracingRedissonHelper.decorate(span, () -> this.cache.stream(pattern));
    }

    public Iterator<V> iterator(int count) {
        return this.cache.iterator(count);
    }

    public Iterator<V> iterator(String pattern, int count) {
        return this.cache.iterator(pattern, count);
    }

    public Iterator<V> iterator(String pattern) {
        return this.cache.iterator(pattern);
    }

    public <KOut, VOut> RCollectionMapReduce<V, KOut, VOut> mapReduce() {
        return new TracingRCollectionMapReduce(this.cache.mapReduce(), this.tracingRedissonHelper);
    }

    public boolean add(V value, long ttl, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("add", (RObject)this.cache);
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.cache.add(value, ttl, unit));
    }

    public int size() {
        Span span = this.tracingRedissonHelper.buildSpan("size", (RObject)this.cache);
        return (Integer)this.tracingRedissonHelper.decorate(span, () -> this.cache.size());
    }

    public Set<V> readAll() {
        Span span = this.tracingRedissonHelper.buildSpan("readAll", (RObject)this.cache);
        return (Set)this.tracingRedissonHelper.decorate(span, () -> this.cache.readAll());
    }

    public boolean isEmpty() {
        Span span = this.tracingRedissonHelper.buildSpan("isEmpty", (RObject)this.cache);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.cache.isEmpty());
    }

    public boolean contains(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("contains", (RObject)this.cache);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.cache.contains(o));
    }

    public Iterator<V> iterator() {
        return this.cache.iterator();
    }

    public Object[] toArray() {
        Span span = this.tracingRedissonHelper.buildSpan("toArray", (RObject)this.cache);
        return (Object[])this.tracingRedissonHelper.decorate(span, () -> this.cache.toArray());
    }

    public <T> T[] toArray(T[] a) {
        Span span = this.tracingRedissonHelper.buildSpan("toArray", (RObject)this.cache);
        return (Object[])this.tracingRedissonHelper.decorate(span, () -> this.cache.toArray(a));
    }

    public boolean add(V element) {
        Span span = this.tracingRedissonHelper.buildSpan("add", (RObject)this.cache);
        span.setTag("element", TracingHelper.nullable(element));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.cache.add(element));
    }

    public boolean remove(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("remove", (RObject)this.cache);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.cache.remove(o));
    }

    public boolean containsAll(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("containsAll", (RObject)this.cache);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.cache.containsAll(c));
    }

    public boolean addAll(Collection<? extends V> c) {
        Span span = this.tracingRedissonHelper.buildSpan("addAll", (RObject)this.cache);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.cache.addAll(c));
    }

    public boolean retainAll(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("retainAll", (RObject)this.cache);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.cache.retainAll(c));
    }

    public boolean removeAll(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAll", (RObject)this.cache);
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.cache.removeAll(c));
    }

    public void clear() {
        Span span = this.tracingRedissonHelper.buildSpan("clear", (RObject)this.cache);
        this.tracingRedissonHelper.decorate(span, () -> this.cache.clear());
    }

    public Spliterator<V> spliterator() {
        return this.cache.spliterator();
    }

    public boolean removeIf(Predicate<? super V> filter) {
        Span span = this.tracingRedissonHelper.buildSpan("removeIf", (RObject)this.cache);
        span.setTag("filter", TracingHelper.nullable(filter));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.cache.removeIf(filter));
    }

    public Stream<V> stream() {
        return this.cache.stream();
    }

    public Stream<V> parallelStream() {
        return this.cache.parallelStream();
    }

    public void forEach(Consumer<? super V> action) {
        Span span = this.tracingRedissonHelper.buildSpan("forEach", (RObject)this.cache);
        span.setTag("action", TracingHelper.nullable(action));
        this.tracingRedissonHelper.decorate(span, () -> this.cache.forEach(action));
    }

    public RFuture<Boolean> addAsync(V value, long ttl, TimeUnit unit) {
        Span span = this.tracingRedissonHelper.buildSpan("addAsync", (RObject)this.cache);
        span.setTag("value", TracingHelper.nullable(value));
        span.setTag("ttl", (Number)ttl);
        span.setTag("unit", TracingHelper.nullable((Object)((Object)unit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.cache.addAsync(value, ttl, unit));
    }

    public RFuture<Integer> sizeAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("sizeAsync", (RObject)this.cache);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.cache.sizeAsync());
    }

    public RFuture<Set<V>> readAllAsync() {
        Span span = this.tracingRedissonHelper.buildSpan("readAllAsync", (RObject)this.cache);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.cache.readAllAsync());
    }

    public RFuture<Boolean> retainAllAsync(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("retainAllAsync", (RObject)this.cache);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.cache.retainAllAsync(c));
    }

    public RFuture<Boolean> removeAllAsync(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAllAsync", (RObject)this.cache);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.cache.removeAllAsync(c));
    }

    public RFuture<Boolean> containsAsync(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("containsAsync", (RObject)this.cache);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.cache.containsAsync(o));
    }

    public RFuture<Boolean> containsAllAsync(Collection<?> c) {
        Span span = this.tracingRedissonHelper.buildSpan("containsAllAsync", (RObject)this.cache);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.cache.containsAllAsync(c));
    }

    public RFuture<Boolean> removeAsync(Object o) {
        Span span = this.tracingRedissonHelper.buildSpan("removeAsync", (RObject)this.cache);
        span.setTag("object", TracingHelper.nullable((Object)o));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.cache.removeAsync(o));
    }

    public RFuture<Boolean> addAsync(V e) {
        Span span = this.tracingRedissonHelper.buildSpan("addAsync", (RObject)this.cache);
        span.setTag("element", TracingHelper.nullable(e));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.cache.addAsync(e));
    }

    public RFuture<Boolean> addAllAsync(Collection<? extends V> c) {
        Span span = this.tracingRedissonHelper.buildSpan("addAllAsync", (RObject)this.cache);
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.cache.addAllAsync(c));
    }

    public void destroy() {
        Span span = this.tracingRedissonHelper.buildSpan("destroy", (RObject)this.cache);
        this.tracingRedissonHelper.decorate(span, () -> this.cache.destroy());
    }
}

