/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.Span;
import io.opentracing.contrib.redis.common.TracingHelper;
import io.opentracing.contrib.redis.redisson.TracingRSetMultimap;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.concurrent.TimeUnit;
import org.redisson.api.RFuture;
import org.redisson.api.RObject;
import org.redisson.api.RSetMultimapCache;

public class TracingRSetMultimapCache<K, V>
extends TracingRSetMultimap<K, V>
implements RSetMultimapCache<K, V> {
    private final RSetMultimapCache<K, V> cache;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRSetMultimapCache(RSetMultimapCache<K, V> cache, TracingRedissonHelper tracingRedissonHelper) {
        super(cache, tracingRedissonHelper);
        this.cache = cache;
        this.tracingRedissonHelper = tracingRedissonHelper;
    }

    public boolean expireKey(K key, long timeToLive, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("expireKey", (RObject)this.cache);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("timeToLive", (Number)timeToLive);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        return (Boolean)this.tracingRedissonHelper.decorate(span, () -> this.cache.expireKey(key, timeToLive, timeUnit));
    }

    public RFuture<Boolean> expireKeyAsync(K key, long timeToLive, TimeUnit timeUnit) {
        Span span = this.tracingRedissonHelper.buildSpan("expireKeyAsync", (RObject)this.cache);
        span.setTag("key", TracingHelper.nullable(key));
        span.setTag("timeToLive", (Number)timeToLive);
        span.setTag("timeUnit", TracingHelper.nullable((Object)((Object)timeUnit)));
        return this.tracingRedissonHelper.prepareRFuture(span, () -> this.cache.expireKeyAsync(key, timeToLive, timeUnit));
    }
}

