/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.redis.redisson;

import io.opentracing.contrib.redis.common.TracingConfiguration;
import io.opentracing.contrib.redis.redisson.TracingRAtomicDouble;
import io.opentracing.contrib.redis.redisson.TracingRAtomicLong;
import io.opentracing.contrib.redis.redisson.TracingRBitSet;
import io.opentracing.contrib.redis.redisson.TracingRBlockingDeque;
import io.opentracing.contrib.redis.redisson.TracingRBlockingQueue;
import io.opentracing.contrib.redis.redisson.TracingRBoundedBlockingQueue;
import io.opentracing.contrib.redis.redisson.TracingRBucket;
import io.opentracing.contrib.redis.redisson.TracingRBuckets;
import io.opentracing.contrib.redis.redisson.TracingRCountDownLatch;
import io.opentracing.contrib.redis.redisson.TracingRDelayedQueue;
import io.opentracing.contrib.redis.redisson.TracingRDeque;
import io.opentracing.contrib.redis.redisson.TracingRDoubleAdder;
import io.opentracing.contrib.redis.redisson.TracingRKeys;
import io.opentracing.contrib.redis.redisson.TracingRLexSortedSet;
import io.opentracing.contrib.redis.redisson.TracingRList;
import io.opentracing.contrib.redis.redisson.TracingRListMultimap;
import io.opentracing.contrib.redis.redisson.TracingRLocalCachedMap;
import io.opentracing.contrib.redis.redisson.TracingRLock;
import io.opentracing.contrib.redis.redisson.TracingRLongAdder;
import io.opentracing.contrib.redis.redisson.TracingRMap;
import io.opentracing.contrib.redis.redisson.TracingRMapCache;
import io.opentracing.contrib.redis.redisson.TracingRPermitExpirableSemaphore;
import io.opentracing.contrib.redis.redisson.TracingRPriorityBlockingDeque;
import io.opentracing.contrib.redis.redisson.TracingRPriorityBlockingQueue;
import io.opentracing.contrib.redis.redisson.TracingRPriorityDeque;
import io.opentracing.contrib.redis.redisson.TracingRPriorityQueue;
import io.opentracing.contrib.redis.redisson.TracingRQueue;
import io.opentracing.contrib.redis.redisson.TracingRReadWriteLock;
import io.opentracing.contrib.redis.redisson.TracingRScoredSortedSet;
import io.opentracing.contrib.redis.redisson.TracingRSemaphore;
import io.opentracing.contrib.redis.redisson.TracingRSet;
import io.opentracing.contrib.redis.redisson.TracingRSetCache;
import io.opentracing.contrib.redis.redisson.TracingRSetMultimap;
import io.opentracing.contrib.redis.redisson.TracingRSetMultimapCache;
import io.opentracing.contrib.redis.redisson.TracingRSortedSet;
import io.opentracing.contrib.redis.redisson.TracingRedissonHelper;
import java.util.concurrent.TimeUnit;
import org.redisson.api.BatchOptions;
import org.redisson.api.ClusterNodesGroup;
import org.redisson.api.ExecutorOptions;
import org.redisson.api.LocalCachedMapOptions;
import org.redisson.api.MapOptions;
import org.redisson.api.Node;
import org.redisson.api.NodesGroup;
import org.redisson.api.RAtomicDouble;
import org.redisson.api.RAtomicLong;
import org.redisson.api.RBatch;
import org.redisson.api.RBinaryStream;
import org.redisson.api.RBitSet;
import org.redisson.api.RBlockingDeque;
import org.redisson.api.RBlockingQueue;
import org.redisson.api.RBloomFilter;
import org.redisson.api.RBoundedBlockingQueue;
import org.redisson.api.RBucket;
import org.redisson.api.RBuckets;
import org.redisson.api.RCountDownLatch;
import org.redisson.api.RDelayedQueue;
import org.redisson.api.RDeque;
import org.redisson.api.RDoubleAdder;
import org.redisson.api.RGeo;
import org.redisson.api.RHyperLogLog;
import org.redisson.api.RKeys;
import org.redisson.api.RLexSortedSet;
import org.redisson.api.RList;
import org.redisson.api.RListMultimap;
import org.redisson.api.RListMultimapCache;
import org.redisson.api.RLiveObjectService;
import org.redisson.api.RLocalCachedMap;
import org.redisson.api.RLock;
import org.redisson.api.RLongAdder;
import org.redisson.api.RMap;
import org.redisson.api.RMapCache;
import org.redisson.api.RPatternTopic;
import org.redisson.api.RPermitExpirableSemaphore;
import org.redisson.api.RPriorityBlockingDeque;
import org.redisson.api.RPriorityBlockingQueue;
import org.redisson.api.RPriorityDeque;
import org.redisson.api.RPriorityQueue;
import org.redisson.api.RQueue;
import org.redisson.api.RRateLimiter;
import org.redisson.api.RReadWriteLock;
import org.redisson.api.RRemoteService;
import org.redisson.api.RScheduledExecutorService;
import org.redisson.api.RScoredSortedSet;
import org.redisson.api.RScript;
import org.redisson.api.RSemaphore;
import org.redisson.api.RSet;
import org.redisson.api.RSetCache;
import org.redisson.api.RSetMultimap;
import org.redisson.api.RSetMultimapCache;
import org.redisson.api.RSortedSet;
import org.redisson.api.RStream;
import org.redisson.api.RTopic;
import org.redisson.api.RTransaction;
import org.redisson.api.RedissonClient;
import org.redisson.api.TransactionOptions;
import org.redisson.client.codec.Codec;
import org.redisson.config.Config;

public class TracingRedissonClient
implements RedissonClient {
    private final RedissonClient redissonClient;
    private final TracingRedissonHelper tracingRedissonHelper;

    public TracingRedissonClient(RedissonClient redissonClient, TracingConfiguration configuration) {
        this.redissonClient = redissonClient;
        this.tracingRedissonHelper = new TracingRedissonHelper(configuration);
    }

    public <K, V> RStream<K, V> getStream(String name) {
        return this.redissonClient.getStream(name);
    }

    public <K, V> RStream<K, V> getStream(String name, Codec codec) {
        return this.redissonClient.getStream(name, codec);
    }

    public RRateLimiter getRateLimiter(String name) {
        return this.redissonClient.getRateLimiter(name);
    }

    public RBinaryStream getBinaryStream(String name) {
        return this.redissonClient.getBinaryStream(name);
    }

    public <V> RGeo<V> getGeo(String name) {
        return this.redissonClient.getGeo(name);
    }

    public <V> RGeo<V> getGeo(String name, Codec codec) {
        return this.redissonClient.getGeo(name, codec);
    }

    public <V> RSetCache<V> getSetCache(String name) {
        return new TracingRSetCache(this.redissonClient.getSetCache(name), this.tracingRedissonHelper);
    }

    public <V> RSetCache<V> getSetCache(String name, Codec codec) {
        return new TracingRSetCache(this.redissonClient.getSetCache(name, codec), this.tracingRedissonHelper);
    }

    public <K, V> RMapCache<K, V> getMapCache(String name, Codec codec) {
        return new TracingRMapCache(this.redissonClient.getMapCache(name, codec), this.tracingRedissonHelper);
    }

    public <K, V> RMapCache<K, V> getMapCache(String name, Codec codec, MapOptions<K, V> options) {
        return new TracingRMapCache(this.redissonClient.getMapCache(name, codec, options), this.tracingRedissonHelper);
    }

    public <K, V> RMapCache<K, V> getMapCache(String name) {
        return new TracingRMapCache(this.redissonClient.getMapCache(name), this.tracingRedissonHelper);
    }

    public <K, V> RMapCache<K, V> getMapCache(String name, MapOptions<K, V> options) {
        return new TracingRMapCache(this.redissonClient.getMapCache(name, options), this.tracingRedissonHelper);
    }

    public <V> RBucket<V> getBucket(String name) {
        return new TracingRBucket(this.redissonClient.getBucket(name), this.tracingRedissonHelper);
    }

    public <V> RBucket<V> getBucket(String name, Codec codec) {
        return new TracingRBucket(this.redissonClient.getBucket(name, codec), this.tracingRedissonHelper);
    }

    public RBuckets getBuckets() {
        return new TracingRBuckets(this.redissonClient.getBuckets(), this.tracingRedissonHelper);
    }

    public RBuckets getBuckets(Codec codec) {
        return new TracingRBuckets(this.redissonClient.getBuckets(codec), this.tracingRedissonHelper);
    }

    public <V> RHyperLogLog<V> getHyperLogLog(String name) {
        return this.redissonClient.getHyperLogLog(name);
    }

    public <V> RHyperLogLog<V> getHyperLogLog(String name, Codec codec) {
        return this.redissonClient.getHyperLogLog(name, codec);
    }

    public <V> RList<V> getList(String name) {
        return new TracingRList(this.redissonClient.getList(name), this.tracingRedissonHelper);
    }

    public <V> RList<V> getList(String name, Codec codec) {
        return new TracingRList(this.redissonClient.getList(name, codec), this.tracingRedissonHelper);
    }

    public <K, V> RListMultimap<K, V> getListMultimap(String name) {
        return new TracingRListMultimap(this.redissonClient.getListMultimap(name), this.tracingRedissonHelper);
    }

    public <K, V> RListMultimap<K, V> getListMultimap(String name, Codec codec) {
        return new TracingRListMultimap(this.redissonClient.getListMultimap(name, codec), this.tracingRedissonHelper);
    }

    public <K, V> RListMultimapCache<K, V> getListMultimapCache(String name) {
        return this.redissonClient.getListMultimapCache(name);
    }

    public <K, V> RListMultimapCache<K, V> getListMultimapCache(String name, Codec codec) {
        return this.redissonClient.getListMultimapCache(name, codec);
    }

    public <K, V> RLocalCachedMap<K, V> getLocalCachedMap(String name, LocalCachedMapOptions<K, V> options) {
        return new TracingRLocalCachedMap(this.redissonClient.getLocalCachedMap(name, options), this.tracingRedissonHelper);
    }

    public <K, V> RLocalCachedMap<K, V> getLocalCachedMap(String name, Codec codec, LocalCachedMapOptions<K, V> options) {
        return new TracingRLocalCachedMap(this.redissonClient.getLocalCachedMap(name, codec, options), this.tracingRedissonHelper);
    }

    public <K, V> RMap<K, V> getMap(String name) {
        return new TracingRMap(this.redissonClient.getMap(name), this.tracingRedissonHelper);
    }

    public <K, V> RMap<K, V> getMap(String name, MapOptions<K, V> options) {
        return new TracingRMap(this.redissonClient.getMap(name, options), this.tracingRedissonHelper);
    }

    public <K, V> RMap<K, V> getMap(String name, Codec codec) {
        return new TracingRMap(this.redissonClient.getMap(name, codec), this.tracingRedissonHelper);
    }

    public <K, V> RMap<K, V> getMap(String name, Codec codec, MapOptions<K, V> options) {
        return new TracingRMap(this.redissonClient.getMap(name, codec, options), this.tracingRedissonHelper);
    }

    public <K, V> RSetMultimap<K, V> getSetMultimap(String name) {
        return new TracingRSetMultimap(this.redissonClient.getSetMultimap(name), this.tracingRedissonHelper);
    }

    public <K, V> RSetMultimap<K, V> getSetMultimap(String name, Codec codec) {
        return new TracingRSetMultimap(this.redissonClient.getSetMultimap(name, codec), this.tracingRedissonHelper);
    }

    public <K, V> RSetMultimapCache<K, V> getSetMultimapCache(String name) {
        return new TracingRSetMultimapCache(this.redissonClient.getSetMultimapCache(name), this.tracingRedissonHelper);
    }

    public <K, V> RSetMultimapCache<K, V> getSetMultimapCache(String name, Codec codec) {
        return new TracingRSetMultimapCache(this.redissonClient.getSetMultimapCache(name, codec), this.tracingRedissonHelper);
    }

    public RSemaphore getSemaphore(String name) {
        return new TracingRSemaphore(this.redissonClient.getSemaphore(name), this.tracingRedissonHelper);
    }

    public RPermitExpirableSemaphore getPermitExpirableSemaphore(String name) {
        return new TracingRPermitExpirableSemaphore(this.redissonClient.getPermitExpirableSemaphore(name), this.tracingRedissonHelper);
    }

    public RLock getLock(String name) {
        return new TracingRLock(this.redissonClient.getLock(name), this.tracingRedissonHelper);
    }

    public RLock getMultiLock(RLock ... locks) {
        return new TracingRLock(this.redissonClient.getMultiLock(locks), this.tracingRedissonHelper);
    }

    public RLock getRedLock(RLock ... locks) {
        return new TracingRLock(this.redissonClient.getRedLock(locks), this.tracingRedissonHelper);
    }

    public RLock getFairLock(String name) {
        return new TracingRLock(this.redissonClient.getFairLock(name), this.tracingRedissonHelper);
    }

    public RReadWriteLock getReadWriteLock(String name) {
        return new TracingRReadWriteLock(this.redissonClient.getReadWriteLock(name), this.tracingRedissonHelper);
    }

    public <V> RSet<V> getSet(String name) {
        return new TracingRSet(this.redissonClient.getSet(name), this.tracingRedissonHelper);
    }

    public <V> RSet<V> getSet(String name, Codec codec) {
        return new TracingRSet(this.redissonClient.getSet(name, codec), this.tracingRedissonHelper);
    }

    public <V> RSortedSet<V> getSortedSet(String name) {
        return new TracingRSortedSet(this.redissonClient.getSortedSet(name), this.tracingRedissonHelper);
    }

    public <V> RSortedSet<V> getSortedSet(String name, Codec codec) {
        return new TracingRSortedSet(this.redissonClient.getSortedSet(name, codec), this.tracingRedissonHelper);
    }

    public <V> RScoredSortedSet<V> getScoredSortedSet(String name) {
        return new TracingRScoredSortedSet(this.redissonClient.getScoredSortedSet(name), this.tracingRedissonHelper);
    }

    public <V> RScoredSortedSet<V> getScoredSortedSet(String name, Codec codec) {
        return new TracingRScoredSortedSet(this.redissonClient.getScoredSortedSet(name, codec), this.tracingRedissonHelper);
    }

    public RLexSortedSet getLexSortedSet(String name) {
        return new TracingRLexSortedSet(this.redissonClient.getLexSortedSet(name), this.tracingRedissonHelper);
    }

    public RTopic getTopic(String name) {
        return this.redissonClient.getTopic(name);
    }

    public RTopic getTopic(String name, Codec codec) {
        return this.redissonClient.getTopic(name, codec);
    }

    public RPatternTopic getPatternTopic(String pattern) {
        return this.redissonClient.getPatternTopic(pattern);
    }

    public RPatternTopic getPatternTopic(String pattern, Codec codec) {
        return this.redissonClient.getPatternTopic(pattern, codec);
    }

    public <V> RQueue<V> getQueue(String name) {
        return new TracingRQueue(this.redissonClient.getQueue(name), this.tracingRedissonHelper);
    }

    public <V> RDelayedQueue<V> getDelayedQueue(RQueue<V> destinationQueue) {
        return new TracingRDelayedQueue(this.redissonClient.getDelayedQueue(destinationQueue), this.tracingRedissonHelper);
    }

    public <V> RQueue<V> getQueue(String name, Codec codec) {
        return new TracingRQueue(this.redissonClient.getQueue(name, codec), this.tracingRedissonHelper);
    }

    public <V> RPriorityQueue<V> getPriorityQueue(String name) {
        return new TracingRPriorityQueue(this.redissonClient.getPriorityQueue(name), this.tracingRedissonHelper);
    }

    public <V> RPriorityQueue<V> getPriorityQueue(String name, Codec codec) {
        return new TracingRPriorityQueue(this.redissonClient.getPriorityQueue(name, codec), this.tracingRedissonHelper);
    }

    public <V> RPriorityBlockingQueue<V> getPriorityBlockingQueue(String name) {
        return new TracingRPriorityBlockingQueue(this.redissonClient.getPriorityBlockingQueue(name), this.tracingRedissonHelper);
    }

    public <V> RPriorityBlockingQueue<V> getPriorityBlockingQueue(String name, Codec codec) {
        return new TracingRPriorityBlockingQueue(this.redissonClient.getPriorityBlockingQueue(name, codec), this.tracingRedissonHelper);
    }

    public <V> RPriorityBlockingDeque<V> getPriorityBlockingDeque(String name) {
        return new TracingRPriorityBlockingDeque(this.redissonClient.getPriorityBlockingDeque(name), this.tracingRedissonHelper);
    }

    public <V> RPriorityBlockingDeque<V> getPriorityBlockingDeque(String name, Codec codec) {
        return new TracingRPriorityBlockingDeque(this.redissonClient.getPriorityBlockingDeque(name, codec), this.tracingRedissonHelper);
    }

    public <V> RPriorityDeque<V> getPriorityDeque(String name) {
        return new TracingRPriorityDeque(this.redissonClient.getPriorityDeque(name), this.tracingRedissonHelper);
    }

    public <V> RPriorityDeque<V> getPriorityDeque(String name, Codec codec) {
        return new TracingRPriorityDeque(this.redissonClient.getPriorityDeque(name, codec), this.tracingRedissonHelper);
    }

    public <V> RBlockingQueue<V> getBlockingQueue(String name) {
        return new TracingRBlockingQueue(this.redissonClient.getBlockingQueue(name), this.tracingRedissonHelper);
    }

    public <V> RBlockingQueue<V> getBlockingQueue(String name, Codec codec) {
        return new TracingRBlockingQueue(this.redissonClient.getBlockingQueue(name, codec), this.tracingRedissonHelper);
    }

    public <V> RBoundedBlockingQueue<V> getBoundedBlockingQueue(String name) {
        return new TracingRBoundedBlockingQueue(this.redissonClient.getBoundedBlockingQueue(name), this.tracingRedissonHelper);
    }

    public <V> RBoundedBlockingQueue<V> getBoundedBlockingQueue(String name, Codec codec) {
        return new TracingRBoundedBlockingQueue(this.redissonClient.getBoundedBlockingQueue(name, codec), this.tracingRedissonHelper);
    }

    public <V> RDeque<V> getDeque(String name) {
        return new TracingRDeque(this.redissonClient.getDeque(name), this.tracingRedissonHelper);
    }

    public <V> RDeque<V> getDeque(String name, Codec codec) {
        return new TracingRDeque(this.redissonClient.getDeque(name, codec), this.tracingRedissonHelper);
    }

    public <V> RBlockingDeque<V> getBlockingDeque(String name) {
        return new TracingRBlockingDeque(this.redissonClient.getBlockingDeque(name), this.tracingRedissonHelper);
    }

    public <V> RBlockingDeque<V> getBlockingDeque(String name, Codec codec) {
        return new TracingRBlockingDeque(this.redissonClient.getBlockingDeque(name, codec), this.tracingRedissonHelper);
    }

    public RAtomicLong getAtomicLong(String name) {
        return new TracingRAtomicLong(this.redissonClient.getAtomicLong(name), this.tracingRedissonHelper);
    }

    public RAtomicDouble getAtomicDouble(String name) {
        return new TracingRAtomicDouble(this.redissonClient.getAtomicDouble(name), this.tracingRedissonHelper);
    }

    public RLongAdder getLongAdder(String name) {
        return new TracingRLongAdder(this.redissonClient.getLongAdder(name), this.tracingRedissonHelper);
    }

    public RDoubleAdder getDoubleAdder(String name) {
        return new TracingRDoubleAdder(this.redissonClient.getDoubleAdder(name), this.tracingRedissonHelper);
    }

    public RCountDownLatch getCountDownLatch(String name) {
        return new TracingRCountDownLatch(this.redissonClient.getCountDownLatch(name), this.tracingRedissonHelper);
    }

    public RBitSet getBitSet(String name) {
        return new TracingRBitSet(this.redissonClient.getBitSet(name), this.tracingRedissonHelper);
    }

    public <V> RBloomFilter<V> getBloomFilter(String name) {
        return this.redissonClient.getBloomFilter(name);
    }

    public <V> RBloomFilter<V> getBloomFilter(String name, Codec codec) {
        return this.redissonClient.getBloomFilter(name, codec);
    }

    public RScript getScript() {
        return this.redissonClient.getScript();
    }

    public RScript getScript(Codec codec) {
        return this.redissonClient.getScript(codec);
    }

    public RScheduledExecutorService getExecutorService(String name) {
        return this.redissonClient.getExecutorService(name);
    }

    public RScheduledExecutorService getExecutorService(String name, ExecutorOptions options) {
        return this.redissonClient.getExecutorService(name, options);
    }

    @Deprecated
    public RScheduledExecutorService getExecutorService(Codec codec, String name) {
        return this.redissonClient.getExecutorService(codec, name);
    }

    public RScheduledExecutorService getExecutorService(String name, Codec codec) {
        return this.redissonClient.getExecutorService(name, codec);
    }

    public RScheduledExecutorService getExecutorService(String name, Codec codec, ExecutorOptions options) {
        return this.redissonClient.getExecutorService(name, codec, options);
    }

    public RRemoteService getRemoteService() {
        return this.redissonClient.getRemoteService();
    }

    public RRemoteService getRemoteService(Codec codec) {
        return this.redissonClient.getRemoteService(codec);
    }

    public RRemoteService getRemoteService(String name) {
        return this.redissonClient.getRemoteService(name);
    }

    public RRemoteService getRemoteService(String name, Codec codec) {
        return this.redissonClient.getRemoteService(name, codec);
    }

    public RTransaction createTransaction(TransactionOptions options) {
        return this.redissonClient.createTransaction(options);
    }

    public RBatch createBatch(BatchOptions options) {
        return this.redissonClient.createBatch(options);
    }

    @Deprecated
    public RBatch createBatch() {
        return this.redissonClient.createBatch();
    }

    public RKeys getKeys() {
        return new TracingRKeys(this.redissonClient.getKeys(), this.tracingRedissonHelper);
    }

    public RLiveObjectService getLiveObjectService() {
        return this.redissonClient.getLiveObjectService();
    }

    public void shutdown() {
        this.redissonClient.shutdown();
    }

    public void shutdown(long quietPeriod, long timeout, TimeUnit unit) {
        this.redissonClient.shutdown(quietPeriod, timeout, unit);
    }

    public Config getConfig() {
        return this.redissonClient.getConfig();
    }

    public NodesGroup<Node> getNodesGroup() {
        return this.redissonClient.getNodesGroup();
    }

    public ClusterNodesGroup getClusterNodesGroup() {
        return this.redissonClient.getClusterNodesGroup();
    }

    public boolean isShutdown() {
        return this.redissonClient.isShutdown();
    }

    public boolean isShuttingDown() {
        return this.redissonClient.isShuttingDown();
    }
}

