/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.rxjava;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.rxjava.AbstractTracingSubscriber;
import io.opentracing.rxjava.TracingEmptyAction;
import rx.functions.Action0;
import rx.functions.Action1;
import rx.internal.util.InternalObservableUtils;

public class TracingActionSubscriber<T>
extends AbstractTracingSubscriber<T> {
    private final Action1<? super T> onNext;
    private final Action1<Throwable> onError;
    private final Action0 onCompleted;
    private final Tracer tracer;

    public TracingActionSubscriber(String operationName, Tracer tracer) {
        this(operationName, "rxjava-1", tracer);
    }

    public TracingActionSubscriber(String operationName, String componentName, Tracer tracer) {
        this(TracingEmptyAction.empty(), operationName, componentName, tracer);
    }

    public TracingActionSubscriber(Action1<? super T> onNext, String operationName, Tracer tracer) {
        this(onNext, operationName, "rxjava-1", tracer);
    }

    public TracingActionSubscriber(Action1<? super T> onNext, String operationName, String componentName, Tracer tracer) {
        this(onNext, (Action1<Throwable>)InternalObservableUtils.ERROR_NOT_IMPLEMENTED, operationName, componentName, tracer);
    }

    public TracingActionSubscriber(Action1<? super T> onNext, Action1<Throwable> onError, String operationName, Tracer tracer) {
        this(onNext, onError, operationName, "rxjava-1", tracer);
    }

    public TracingActionSubscriber(Action1<? super T> onNext, Action1<Throwable> onError, String operationName, String componentName, Tracer tracer) {
        this(onNext, onError, TracingEmptyAction.empty(), operationName, componentName, tracer);
    }

    public TracingActionSubscriber(Action1<? super T> onNext, Action1<Throwable> onError, Action0 onCompleted, String operationName, Tracer tracer) {
        this(onNext, onError, onCompleted, operationName, "rxjava-1", tracer);
    }

    public TracingActionSubscriber(Action1<? super T> onNext, Action1<Throwable> onError, Action0 onCompleted, String operationName, String componentName, Tracer tracer) {
        super(operationName, componentName, tracer);
        if (onNext == null) {
            throw new IllegalArgumentException("onNext can not be null");
        }
        if (onError == null) {
            throw new IllegalArgumentException("onError can not be null");
        }
        if (onCompleted == null) {
            throw new IllegalArgumentException("onComplete can not be null");
        }
        this.onNext = onNext;
        this.onError = onError;
        this.onCompleted = onCompleted;
        this.tracer = tracer;
    }

    @Override
    public void onNext(T t) {
        Span span = this.getSpan();
        Span activeSpan = this.tracer.activeSpan();
        if (span != null && !span.equals(activeSpan)) {
            try (Scope ignore = this.tracer.scopeManager().activate(this.getSpan());){
                this.onNext.call(t);
            }
        } else {
            this.onNext.call(t);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onError(Throwable e) {
        block16: {
            try {
                Span span = this.getSpan();
                Span activeSpan = this.tracer.activeSpan();
                if (span != null && !span.equals(activeSpan)) {
                    try (Scope ignore = this.tracer.scopeManager().activate(this.getSpan());){
                        this.onError.call((Object)e);
                        break block16;
                    }
                }
                this.onError.call((Object)e);
            }
            finally {
                super.onError(e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void onCompleted() {
        block16: {
            try {
                Span span = this.getSpan();
                Span activeSpan = this.tracer.activeSpan();
                if (span != null && !span.equals(activeSpan)) {
                    try (Scope ignore = this.tracer.scopeManager().activate(this.getSpan());){
                        this.onCompleted.call();
                        break block16;
                    }
                }
                this.onCompleted.call();
            }
            finally {
                super.onCompleted();
            }
        }
    }
}

