/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spanmanager.tracer;

import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.contrib.spanmanager.SpanManager;
import io.opentracing.contrib.spanmanager.tracer.ManagedSpanBuilder;
import io.opentracing.propagation.Format;

public final class ManagedSpanTracer
implements Tracer {
    private final Tracer delegate;
    private final SpanManager spanManager;

    public ManagedSpanTracer(Tracer delegate, SpanManager spanManager) {
        if (delegate == null) {
            throw new NullPointerException("Delegate Tracer is <null>.");
        }
        if (spanManager == null) {
            throw new NullPointerException("Span manager is <null>.");
        }
        this.delegate = delegate;
        this.spanManager = spanManager;
    }

    public <C> void inject(SpanContext spanContext, Format<C> format, C carrier) {
        if (spanContext instanceof ManagedSpanBuilder) {
            spanContext = ((ManagedSpanBuilder)spanContext).delegate;
        }
        this.delegate.inject(spanContext, format, carrier);
    }

    public <C> SpanContext extract(Format<C> format, C carrier) {
        return this.delegate.extract(format, carrier);
    }

    public Tracer.SpanBuilder buildSpan(String operationName) {
        return new ManagedSpanBuilder(this.delegate.buildSpan(operationName), this.spanManager);
    }

    public String toString() {
        return "ManagedSpanTracer{" + this.delegate + '}';
    }
}

