/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.async;

import io.opentracing.Tracer;
import io.opentracing.contrib.concurrent.TracedExecutor;
import io.opentracing.contrib.spring.cloud.async.CustomAsyncConfigurerAutoConfiguration;
import io.opentracing.contrib.spring.cloud.async.ExecutorBeanPostProcessor;
import io.opentracing.contrib.spring.cloud.async.TraceAsyncAspect;
import io.opentracing.contrib.spring.cloud.async.TracedAsyncWebAspect;
import io.opentracing.contrib.spring.tracer.configuration.TracerAutoConfiguration;
import java.util.concurrent.Executor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.context.annotation.Lazy;
import org.springframework.core.task.SimpleAsyncTaskExecutor;
import org.springframework.scheduling.annotation.AsyncConfigurer;
import org.springframework.scheduling.annotation.AsyncConfigurerSupport;
import org.springframework.scheduling.annotation.EnableAsync;

@EnableAsync
@Configuration
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={CustomAsyncConfigurerAutoConfiguration.class, TracerAutoConfiguration.class})
@ConditionalOnProperty(name={"opentracing.spring.cloud.async.enabled"}, havingValue="true", matchIfMissing=true)
public class DefaultAsyncAutoConfiguration {
    @Autowired
    @Lazy
    private Tracer tracer;

    @Bean
    public ExecutorBeanPostProcessor executorBeanPostProcessor() {
        return new ExecutorBeanPostProcessor(this.tracer);
    }

    @Bean
    public TraceAsyncAspect traceAsyncAspect() {
        return new TraceAsyncAspect(this.tracer);
    }

    @Bean
    public TracedAsyncWebAspect tracedAsyncWebAspect() {
        return new TracedAsyncWebAspect(this.tracer);
    }

    @Configuration
    @ConditionalOnMissingBean(value={AsyncConfigurer.class})
    static class DefaultTracedAsyncConfigurerSupport
    extends AsyncConfigurerSupport {
        @Autowired
        @Lazy
        private Tracer tracer;

        DefaultTracedAsyncConfigurerSupport() {
        }

        public Executor getAsyncExecutor() {
            return new TracedExecutor((Executor)new SimpleAsyncTaskExecutor(), this.tracer);
        }
    }
}

