/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.async;

import io.opentracing.Tracer;
import io.opentracing.contrib.concurrent.TracedExecutor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.concurrent.Executor;
import org.aopalliance.intercept.MethodInterceptor;
import org.aopalliance.intercept.MethodInvocation;
import org.springframework.util.ReflectionUtils;

class ExecutorMethodInterceptor<T extends Executor>
implements MethodInterceptor {
    private final T delegate;
    private final Tracer tracer;

    ExecutorMethodInterceptor(T delegate, Tracer tracer) {
        this.delegate = delegate;
        this.tracer = tracer;
    }

    public Object invoke(MethodInvocation invocation) throws Throwable {
        Executor tracedExecutor = this.tracedExecutor(this.tracer, this.delegate);
        Method methodOnTracedBean = this.getMethod(invocation, tracedExecutor);
        if (methodOnTracedBean != null) {
            try {
                return methodOnTracedBean.invoke((Object)tracedExecutor, invocation.getArguments());
            }
            catch (InvocationTargetException ex) {
                throw ex.getCause();
            }
        }
        return invocation.proceed();
    }

    private Method getMethod(MethodInvocation invocation, Object object) {
        Method method = invocation.getMethod();
        return ReflectionUtils.findMethod(object.getClass(), (String)method.getName(), (Class[])method.getParameterTypes());
    }

    Executor tracedExecutor(Tracer tracer, T executor) {
        return new TracedExecutor(executor, tracer);
    }
}

