/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.async;

import io.opentracing.Tracer;
import io.opentracing.contrib.concurrent.TracedCallable;
import java.lang.reflect.Field;
import java.util.concurrent.Callable;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.web.context.request.async.WebAsyncTask;

@Aspect
public class TracedAsyncWebAspect {
    private Tracer tracer;

    public TracedAsyncWebAspect(Tracer tracer) {
        this.tracer = tracer;
    }

    @Pointcut(value="@within(org.springframework.web.bind.annotation.RestController)")
    private void anyRestControllerAnnotated() {
    }

    @Pointcut(value="@within(org.springframework.stereotype.Controller)")
    private void anyControllerAnnotated() {
    }

    @Pointcut(value="execution(public java.util.concurrent.Callable *(..))")
    private void anyPublicMethodReturningCallable() {
    }

    @Pointcut(value="(anyRestControllerAnnotated() || anyControllerAnnotated()) && anyPublicMethodReturningCallable()")
    private void anyControllerOrRestControllerWithPublicAsyncMethod() {
    }

    @Pointcut(value="execution(public org.springframework.web.context.request.async.WebAsyncTask *(..))")
    private void anyPublicMethodReturningWebAsyncTask() {
    }

    @Pointcut(value="(anyRestControllerAnnotated() || anyControllerAnnotated()) && anyPublicMethodReturningWebAsyncTask()")
    private void anyControllerOrRestControllerWithPublicWebAsyncTaskMethod() {
    }

    @Around(value="anyControllerOrRestControllerWithPublicAsyncMethod()")
    public Object tracePublicAsyncMethods(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        Callable delegate = (Callable)proceedingJoinPoint.proceed();
        return new TracedCallable(delegate, this.tracer);
    }

    @Around(value="anyControllerOrRestControllerWithPublicWebAsyncTaskMethod()")
    public Object tracePublicWebAsyncTaskMethods(ProceedingJoinPoint proceedingJoinPoint) throws Throwable {
        WebAsyncTask webAsyncTask = (WebAsyncTask)proceedingJoinPoint.proceed();
        Field callableField = WebAsyncTask.class.getDeclaredField("callable");
        callableField.setAccessible(true);
        callableField.set(webAsyncTask, new TracedCallable(webAsyncTask.getCallable(), this.tracer));
        return webAsyncTask;
    }
}

