/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.gateway;

import io.opentracing.Tracer;
import io.opentracing.contrib.spring.cloud.gateway.TraceRequestHttpHeadersFilter;
import io.opentracing.contrib.spring.cloud.gateway.TraceResponseHttpHeadersFilter;
import io.opentracing.contrib.spring.tracer.configuration.TracerAutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.cloud.gateway.filter.GatewayFilterChain;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@ConditionalOnWebApplication
@AutoConfigureAfter(value={TracerAutoConfiguration.class})
@ConditionalOnClass(value={GatewayFilterChain.class})
@ConditionalOnProperty(name={"opentracing.spring.cloud.gateway.enabled"}, havingValue="true", matchIfMissing=true)
public class GatewayTracingAutoConfiguration {
    @Bean
    @ConditionalOnClass(value={HttpHeadersFilter.class})
    @ConditionalOnBean(value={Tracer.class})
    HttpHeadersFilter traceRequestHttpHeadersFilter(Tracer tracer) {
        return new TraceRequestHttpHeadersFilter(tracer);
    }

    @Bean
    @ConditionalOnClass(value={HttpHeadersFilter.class})
    @ConditionalOnBean(value={Tracer.class})
    HttpHeadersFilter traceResponseHttpHeadersFilter(Tracer tracer) {
        return new TraceResponseHttpHeadersFilter(tracer);
    }
}

