/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.gateway;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.spring.cloud.gateway.AbstractHttpHeadersFilter;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cloud.gateway.filter.headers.HttpHeadersFilter;
import org.springframework.http.HttpHeaders;
import org.springframework.web.server.ServerWebExchange;

public class TraceResponseHttpHeadersFilter
extends AbstractHttpHeadersFilter {
    private final Logger log = LoggerFactory.getLogger(TraceResponseHttpHeadersFilter.class);

    protected TraceResponseHttpHeadersFilter(Tracer tracer) {
        super(tracer);
    }

    public HttpHeaders filter(HttpHeaders input, ServerWebExchange exchange) {
        Object storedSpan = exchange.getAttribute(SPAN_ATTRIBUTE);
        if (storedSpan == null) {
            return input;
        }
        this.log.debug("Will instrument the response");
        Span span = (Span)storedSpan;
        if (Objects.nonNull(span)) {
            span.finish();
        }
        this.log.debug("The response was handled for span " + storedSpan);
        return input;
    }

    public boolean supports(HttpHeadersFilter.Type type) {
        return type.equals((Object)HttpHeadersFilter.Type.RESPONSE);
    }
}

