/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.cloud.mongo;

import com.mongodb.MongoClient;
import io.opentracing.Tracer;
import io.opentracing.contrib.mongo.TracingMongoClient;
import io.opentracing.contrib.mongo.common.TracingCommandListener;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanPostProcessor;

class TracingMongoClientPostProcessor
implements BeanPostProcessor {
    private final Tracer tracer;

    TracingMongoClientPostProcessor(Tracer tracer) {
        this.tracer = tracer;
    }

    public Object postProcessAfterInitialization(Object bean, String beanName) throws BeansException {
        if (bean instanceof MongoClient && !(bean instanceof TracingMongoClient)) {
            MongoClient client = (MongoClient)bean;
            TracingCommandListener commandListener = new TracingCommandListener.Builder(this.tracer).build();
            return new TracingMongoClient(commandListener, client.getServerAddressList(), client.getCredentialsList(), client.getMongoClientOptions());
        }
        return bean;
    }
}

