/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.tracer.configuration;

import io.opentracing.Tracer;
import io.opentracing.contrib.tracerresolver.TracerResolver;
import io.opentracing.noop.NoopTracerFactory;
import io.opentracing.util.GlobalTracer;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class TracerAutoConfiguration {
    private static final Log log = LogFactory.getLog((String)TracerAutoConfiguration.class.getName());

    @Bean
    @ConditionalOnMissingBean(value={Tracer.class})
    public Tracer getTracer() {
        Tracer tracer;
        if (GlobalTracer.isRegistered()) {
            log.warn((Object)"GlobalTracer is already registered. For consistency it is best practice to provide a Tracer bean instead of manually registering it with the GlobalTracer");
            tracer = GlobalTracer.get();
        } else {
            tracer = TracerResolver.resolveTracer();
            if (tracer == null) {
                tracer = NoopTracerFactory.create();
            }
        }
        log.warn((Object)("Tracer bean is not configured! Switching to " + tracer));
        return tracer;
    }
}

