/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.autoconfig;

import io.opentracing.Tracer;
import io.opentracing.contrib.spring.web.autoconfig.TracerAutoConfiguration;
import io.opentracing.contrib.spring.web.client.TracingAsyncRestTemplateInterceptor;
import java.util.ArrayList;
import java.util.Set;
import javax.annotation.PostConstruct;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.context.annotation.Configuration;
import org.springframework.http.client.AsyncClientHttpRequestInterceptor;
import org.springframework.web.client.AsyncRestTemplate;

@Configuration
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={TracerAutoConfiguration.class})
public class AsyncRestTemplateAutoConfiguration {
    private static final Log log = LogFactory.getLog(AsyncRestTemplateAutoConfiguration.class);
    @Autowired(required=false)
    private Set<AsyncRestTemplate> restTemplates;
    @Autowired
    private Tracer tracer;

    @PostConstruct
    public void init() {
        if (this.restTemplates != null) {
            for (AsyncRestTemplate restTemplate : this.restTemplates) {
                this.registerTracingInterceptor(restTemplate);
            }
        }
    }

    private void registerTracingInterceptor(AsyncRestTemplate restTemplate) {
        ArrayList<TracingAsyncRestTemplateInterceptor> interceptors = restTemplate.getInterceptors();
        for (AsyncClientHttpRequestInterceptor asyncClientHttpRequestInterceptor : interceptors) {
            if (!(asyncClientHttpRequestInterceptor instanceof TracingAsyncRestTemplateInterceptor)) continue;
            return;
        }
        log.info((Object)("Adding " + TracingAsyncRestTemplateInterceptor.class.getSimpleName() + " to async rest template"));
        interceptors = new ArrayList<TracingAsyncRestTemplateInterceptor>(interceptors);
        interceptors.add(new TracingAsyncRestTemplateInterceptor(this.tracer));
        restTemplate.setInterceptors(interceptors);
    }
}

