/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.autoconfig;

import io.opentracing.Tracer;
import io.opentracing.contrib.spring.web.autoconfig.TracerAutoConfiguration;
import io.opentracing.contrib.spring.web.autoconfig.WebTracingProperties;
import io.opentracing.contrib.spring.web.interceptor.HandlerInterceptorSpanDecorator;
import io.opentracing.contrib.spring.web.interceptor.TracingHandlerInterceptor;
import io.opentracing.contrib.web.servlet.filter.ServletFilterSpanDecorator;
import io.opentracing.contrib.web.servlet.filter.TracingFilter;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.servlet.Filter;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.springframework.beans.factory.ObjectProvider;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnWebApplication;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.boot.web.servlet.ServletRegistrationBean;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.util.CollectionUtils;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurerAdapter;

@Configuration
@ConditionalOnWebApplication
@ConditionalOnBean(value={Tracer.class})
@AutoConfigureAfter(value={TracerAutoConfiguration.class})
@EnableConfigurationProperties(value={WebTracingProperties.class})
public class ServerTracingAutoConfiguration {
    private static final Log log = LogFactory.getLog(ServerTracingAutoConfiguration.class);
    private final ObjectProvider<List<ServletFilterSpanDecorator>> servletFilterSpanDecorator;
    private final ObjectProvider<List<HandlerInterceptorSpanDecorator>> interceptorSpanDecorator;

    public ServerTracingAutoConfiguration(ObjectProvider<List<ServletFilterSpanDecorator>> servletFilterSpanDecorator, ObjectProvider<List<HandlerInterceptorSpanDecorator>> interceptorSpanDecorator) {
        this.servletFilterSpanDecorator = servletFilterSpanDecorator;
        this.interceptorSpanDecorator = interceptorSpanDecorator;
    }

    @Bean
    @ConditionalOnMissingBean(value={TracingFilter.class})
    public FilterRegistrationBean tracingFilter(Tracer tracer, WebTracingProperties tracingConfiguration) {
        log.info((Object)String.format("Creating %s bean with %s mapped to %s, skip pattern is \"%s\"", FilterRegistrationBean.class.getSimpleName(), TracingFilter.class.getSimpleName(), tracingConfiguration.getUrlPatterns().toString(), tracingConfiguration.getSkipPattern()));
        List<ServletFilterSpanDecorator> decorators = (List<ServletFilterSpanDecorator>)this.servletFilterSpanDecorator.getIfAvailable();
        if (CollectionUtils.isEmpty((Collection)decorators)) {
            decorators = Collections.singletonList(ServletFilterSpanDecorator.STANDARD_TAGS);
        }
        TracingFilter tracingFilter = new TracingFilter(tracer, decorators, tracingConfiguration.getSkipPattern());
        FilterRegistrationBean filterRegistrationBean = new FilterRegistrationBean((Filter)tracingFilter, new ServletRegistrationBean[0]);
        filterRegistrationBean.setUrlPatterns(tracingConfiguration.getUrlPatterns());
        filterRegistrationBean.setOrder(tracingConfiguration.getOrder());
        filterRegistrationBean.setAsyncSupported(true);
        return filterRegistrationBean;
    }

    @Bean
    @ConditionalOnMissingBean(value={TracingFilter.class})
    public WebMvcConfigurerAdapter tracingHandlerInterceptor(final Tracer tracer) {
        log.info((Object)("Creating " + WebMvcConfigurerAdapter.class.getSimpleName() + " bean with " + TracingHandlerInterceptor.class));
        return new WebMvcConfigurerAdapter(){

            public void addInterceptors(InterceptorRegistry registry) {
                List<HandlerInterceptorSpanDecorator> decorators = (List<HandlerInterceptorSpanDecorator>)ServerTracingAutoConfiguration.this.interceptorSpanDecorator.getIfAvailable();
                if (CollectionUtils.isEmpty((Collection)decorators)) {
                    decorators = Arrays.asList(HandlerInterceptorSpanDecorator.STANDARD_LOGS, HandlerInterceptorSpanDecorator.HANDLER_METHOD_OPERATION_NAME);
                }
                registry.addInterceptor((HandlerInterceptor)new TracingHandlerInterceptor(tracer, (List)decorators));
                super.addInterceptors(registry);
            }
        };
    }
}

