/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.webfilter;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.net.Inet6Address;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.TimeoutException;
import org.springframework.http.server.reactive.ServerHttpRequest;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.reactive.HandlerMapping;
import org.springframework.web.server.ServerWebExchange;

public interface WebFluxSpanDecorator {
    public void onRequest(ServerWebExchange var1, Span var2);

    public void onResponse(ServerWebExchange var1, Span var2);

    public void onError(ServerWebExchange var1, Throwable var2, Span var3);

    public static class WebFluxTags
    implements WebFluxSpanDecorator {
        @Override
        public void onRequest(ServerWebExchange exchange, Span span) {
        }

        @Override
        public void onResponse(ServerWebExchange exchange, Span span) {
            this.addWebFluxTags(exchange, span);
        }

        @Override
        public void onError(ServerWebExchange exchange, Throwable exception, Span span) {
            this.addWebFluxTags(exchange, span);
        }

        private void addWebFluxTags(ServerWebExchange exchange, Span span) {
            String patternAsString;
            Object handler = exchange.getAttribute(HandlerMapping.BEST_MATCHING_HANDLER_ATTRIBUTE);
            if (handler == null) {
                return;
            }
            HashMap<String, String> logs = new HashMap<String, String>(4);
            logs.put("event", "handle");
            Object pattern = exchange.getAttribute(HandlerMapping.BEST_MATCHING_PATTERN_ATTRIBUTE);
            String string = patternAsString = pattern == null ? null : pattern.toString();
            if (pattern != null) {
                logs.put("handler", patternAsString);
            }
            if (handler instanceof HandlerMethod) {
                HandlerMethod handlerMethod = (HandlerMethod)handler;
                String methodName = handlerMethod.getMethod().getName();
                logs.put("handler.method_name", handlerMethod.getMethod().getName());
                span.setOperationName(methodName);
                logs.put("handler.class_simple_name", handlerMethod.getBeanType().getSimpleName());
            } else {
                if (pattern != null) {
                    span.setOperationName(patternAsString);
                }
                logs.put("handler.class_simple_name", handler.getClass().getSimpleName());
            }
            span.log(logs);
        }
    }

    public static class StandardTags
    implements WebFluxSpanDecorator {
        static final String COMPONENT_NAME = "java-spring-webflux";

        @Override
        public void onRequest(ServerWebExchange exchange, Span span) {
            Tags.COMPONENT.set(span, COMPONENT_NAME);
            ServerHttpRequest request = exchange.getRequest();
            Tags.HTTP_METHOD.set(span, request.getMethodValue());
            Tags.HTTP_URL.set(span, request.getURI().toString());
            Optional.ofNullable(request.getRemoteAddress()).ifPresent(remoteAddress -> {
                Tags.PEER_HOSTNAME.set(span, remoteAddress.getHostString());
                Tags.PEER_PORT.set(span, Integer.valueOf(remoteAddress.getPort()));
                Optional.ofNullable(remoteAddress.getAddress()).ifPresent(inetAddress -> {
                    if (inetAddress instanceof Inet6Address) {
                        Tags.PEER_HOST_IPV6.set(span, inetAddress.getHostAddress());
                    } else {
                        Tags.PEER_HOST_IPV4.set(span, inetAddress.getHostAddress());
                    }
                });
            });
        }

        @Override
        public void onResponse(ServerWebExchange exchange, Span span) {
            Optional.ofNullable(exchange.getResponse().getStatusCode()).ifPresent(httpStatus -> Tags.HTTP_STATUS.set(span, Integer.valueOf(httpStatus.value())));
        }

        @Override
        public void onError(ServerWebExchange exchange, Throwable exception, Span span) {
            Tags.ERROR.set(span, Boolean.TRUE);
            span.log(this.logsForException(exception));
        }

        private Map<String, Object> logsForException(Throwable throwable) {
            HashMap<String, Object> errorLogs = new HashMap<String, Object>(2);
            errorLogs.put("event", throwable instanceof TimeoutException ? "timed out" : Tags.ERROR.getKey());
            errorLogs.put("error.object", throwable);
            return errorLogs;
        }
    }
}

