/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.contrib.spring.web.client;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.contrib.spring.web.client.HttpHeadersCarrier;
import io.opentracing.contrib.spring.web.client.TracingClientResponseSubscriber;
import io.opentracing.contrib.spring.web.client.WebClientSpanDecorator;
import io.opentracing.propagation.Format;
import io.opentracing.tag.Tags;
import java.util.List;
import org.springframework.http.HttpHeaders;
import org.springframework.web.reactive.function.client.ClientRequest;
import org.springframework.web.reactive.function.client.ClientResponse;
import org.springframework.web.reactive.function.client.ExchangeFunction;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Mono;
import reactor.util.context.Context;

class TracingClientResponseMono
extends Mono<ClientResponse> {
    private final ClientRequest request;
    private final ExchangeFunction next;
    private final Tracer tracer;
    private final List<WebClientSpanDecorator> spanDecorators;

    TracingClientResponseMono(ClientRequest clientRequest, ExchangeFunction next, Tracer tracer, List<WebClientSpanDecorator> spanDecorators) {
        this.request = clientRequest;
        this.next = next;
        this.tracer = tracer;
        this.spanDecorators = spanDecorators;
    }

    public void subscribe(CoreSubscriber<? super ClientResponse> subscriber) {
        Context context = subscriber.currentContext();
        Span parentSpan = context.getOrEmpty(Span.class).orElseGet(() -> ((Tracer)this.tracer).activeSpan());
        Span span = this.tracer.buildSpan(this.request.method().toString()).asChildOf(parentSpan).withTag(Tags.SPAN_KIND.getKey(), "client").start();
        try (Scope scope = this.tracer.scopeManager().activate(span);){
            ClientRequest.Builder requestBuilder = ClientRequest.from((ClientRequest)this.request);
            requestBuilder.headers(httpHeaders -> this.tracer.inject(span.context(), Format.Builtin.HTTP_HEADERS, (Object)new HttpHeadersCarrier((HttpHeaders)httpHeaders)));
            ClientRequest mutatedRequest = requestBuilder.build();
            this.next.exchange(mutatedRequest).subscribe((CoreSubscriber)new TracingClientResponseSubscriber(subscriber, mutatedRequest, context, span, this.spanDecorators));
        }
    }
}

