/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.thrift;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.SpanContext;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import io.opentracing.tag.Tags;
import io.opentracing.thrift.SpanDecorator;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolDecorator;

class ServerInProtocolDecorator
extends TProtocolDecorator {
    private final Tracer tracer;
    private final TMessage message;
    private final Tracer.SpanBuilder spanBuilder;
    private boolean nextSpan;
    private final List<String> mapElements = new ArrayList<String>();
    private Scope activeScope;
    private Span activeSpan;

    ServerInProtocolDecorator(TProtocol protocol, TMessage message, Tracer tracer) {
        super(protocol);
        this.tracer = tracer;
        this.message = message;
        this.spanBuilder = tracer.buildSpan(message.name).withTag(Tags.SPAN_KIND.getKey(), "server");
    }

    public TMessage readMessageBegin() throws TException {
        return this.message;
    }

    public ByteBuffer readBinary() throws TException {
        ByteBuffer byteBuffer = super.readBinary();
        if (this.nextSpan) {
            byte[] bytes = new byte[byteBuffer.remaining()];
            byteBuffer.get(bytes, 0, bytes.length);
            this.mapElements.add(new String(bytes));
        }
        return byteBuffer;
    }

    public TField readFieldBegin() throws TException {
        TField tField = super.readFieldBegin();
        if (tField.id == 3333 && tField.type == 13) {
            this.nextSpan = true;
        }
        return tField;
    }

    public void readFieldEnd() throws TException {
        if (this.nextSpan) {
            this.nextSpan = false;
            this.buildSpan();
        }
        super.readFieldEnd();
    }

    public void readMessageEnd() throws TException {
        if (this.tracer.activeSpan() == null) {
            this.activeSpan = this.spanBuilder.start();
            this.activeScope = this.tracer.activateSpan(this.activeSpan);
            SpanDecorator.decorate(this.activeSpan, this.message);
        }
        super.readMessageEnd();
    }

    private void buildSpan() {
        if (this.mapElements.isEmpty()) {
            return;
        }
        HashMap<String, String> mapSpanContext = new HashMap<String, String>();
        for (int i = 0; i < this.mapElements.size() - 1; i += 2) {
            mapSpanContext.put(this.mapElements.get(i), this.mapElements.get(i + 1));
        }
        SpanContext parent = this.tracer.extract(Format.Builtin.TEXT_MAP, (Object)new TextMapAdapter(mapSpanContext));
        if (parent != null) {
            this.spanBuilder.asChildOf(parent);
        }
        this.activeSpan = this.spanBuilder.start();
        this.activeScope = this.tracer.activateSpan(this.activeSpan);
        SpanDecorator.decorate(this.activeSpan, this.message);
    }

    void closeSpan() {
        if (this.activeSpan != null) {
            this.activeScope.close();
            this.activeScope = null;
        }
        if (this.activeSpan != null) {
            this.activeSpan.finish();
            this.activeSpan = null;
        }
    }
}

