/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.thrift;

import io.opentracing.Tracer;
import io.opentracing.tag.Tags;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolDecorator;

class ServerOutProtocolDecorator
extends TProtocolDecorator {
    private final Tracer tracer;

    ServerOutProtocolDecorator(TProtocol protocol, Tracer tracer) {
        super(protocol);
        this.tracer = tracer;
    }

    public void writeMessageBegin(TMessage tMessage) throws TException {
        if (this.tracer.activeSpan() != null) {
            this.tracer.activeSpan().setTag("message.type", (Number)tMessage.type);
            if (tMessage.type == 3) {
                this.tracer.activeSpan().setTag(Tags.ERROR.getKey(), Boolean.TRUE.booleanValue());
            }
        }
        super.writeMessageBegin(tMessage);
    }
}

