/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.thrift;

import io.opentracing.Span;
import io.opentracing.tag.Tags;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.protocol.TMessage;

class SpanDecorator {
    static final String MESSAGE_TYPE = "message.type";
    static final String COMPONENT_NAME = "java-thrift";

    SpanDecorator() {
    }

    static void decorate(Span span, TMessage message) {
        span.setTag(Tags.COMPONENT.getKey(), COMPONENT_NAME);
        span.setTag("message.name", message.name);
        span.setTag(MESSAGE_TYPE, (Number)message.type);
        span.setTag("message.seqid", (Number)message.seqid);
    }

    static void onError(Throwable throwable, Span span) {
        if (span == null) {
            return;
        }
        span.setTag(Tags.ERROR.getKey(), Boolean.TRUE.booleanValue());
        span.log(SpanDecorator.errorLogs(throwable));
    }

    private static Map<String, Object> errorLogs(Throwable throwable) {
        HashMap<String, Object> errorLogs = new HashMap<String, Object>(3);
        errorLogs.put("event", Tags.ERROR.getKey());
        if (throwable != null) {
            errorLogs.put("error.object", throwable);
        }
        return errorLogs;
    }
}

