/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.thrift;

import io.opentracing.Tracer;
import io.opentracing.thrift.ServerInProtocolDecorator;
import io.opentracing.thrift.ServerOutProtocolDecorator;
import io.opentracing.thrift.SpanDecorator;
import io.opentracing.util.GlobalTracer;
import org.apache.thrift.TException;
import org.apache.thrift.TProcessor;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;

public class SpanProcessor
implements TProcessor {
    private final TProcessor processor;
    private final Tracer tracer;

    public SpanProcessor(TProcessor processor) {
        this(processor, GlobalTracer.get());
    }

    public SpanProcessor(TProcessor processor, Tracer tracer) {
        this.processor = processor;
        this.tracer = tracer;
    }

    public boolean process(TProtocol iprot, TProtocol oprot) throws TException {
        TMessage message = iprot.readMessageBegin();
        if (message.type != 1 && message.type != 4) {
            throw new TException("This should not have happened!?");
        }
        ServerInProtocolDecorator serverInProtocolDecorator = new ServerInProtocolDecorator(iprot, message, this.tracer);
        try {
            boolean bl = this.processor.process((TProtocol)serverInProtocolDecorator, (TProtocol)new ServerOutProtocolDecorator(oprot, this.tracer));
            return bl;
        }
        catch (Exception e) {
            SpanDecorator.onError(e, this.tracer.activeSpan());
            throw e;
        }
        finally {
            serverInProtocolDecorator.closeSpan();
        }
    }
}

