/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.thrift;

import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.propagation.Format;
import io.opentracing.propagation.TextMapAdapter;
import io.opentracing.tag.Tags;
import io.opentracing.thrift.ClientSpanDecorator;
import io.opentracing.thrift.DefaultClientSpanDecorator;
import io.opentracing.thrift.SpanHolder;
import io.opentracing.util.GlobalTracer;
import java.util.HashMap;
import java.util.Map;
import org.apache.thrift.TException;
import org.apache.thrift.protocol.TField;
import org.apache.thrift.protocol.TMap;
import org.apache.thrift.protocol.TMessage;
import org.apache.thrift.protocol.TProtocol;
import org.apache.thrift.protocol.TProtocolDecorator;
import org.apache.thrift.protocol.TProtocolFactory;
import org.apache.thrift.transport.TTransport;
import org.apache.thrift.transport.TTransportException;

public class SpanProtocol
extends TProtocolDecorator {
    private final Tracer tracer;
    private final SpanHolder spanHolder;
    private final boolean finishSpan;
    private final ClientSpanDecorator spanDecorator;
    static final short SPAN_FIELD_ID = 3333;
    private boolean oneWay;
    private boolean injected;

    public SpanProtocol(TProtocol protocol) {
        this(protocol, GlobalTracer.get());
    }

    public SpanProtocol(TProtocol protocol, Tracer tracer) {
        this(protocol, tracer, new DefaultClientSpanDecorator());
    }

    public SpanProtocol(TProtocol protocol, Tracer tracer, ClientSpanDecorator spanDecorator) {
        super(protocol);
        this.tracer = tracer;
        this.spanHolder = new SpanHolder();
        this.finishSpan = true;
        this.spanDecorator = spanDecorator;
    }

    public SpanProtocol(TProtocol protocol, Tracer tracer, SpanHolder spanHolder, boolean finishSpan) {
        super(protocol);
        this.tracer = tracer;
        this.spanHolder = spanHolder;
        this.finishSpan = finishSpan;
        this.spanDecorator = new DefaultClientSpanDecorator();
    }

    public void writeMessageBegin(TMessage tMessage) throws TException {
        Span span = this.tracer.buildSpan(tMessage.name).withTag(Tags.SPAN_KIND.getKey(), "client").start();
        this.spanHolder.setSpan(span);
        this.oneWay = tMessage.type == 4;
        this.injected = false;
        this.spanDecorator.decorate(span, tMessage);
        super.writeMessageBegin(tMessage);
    }

    public void writeMessageEnd() throws TException {
        try {
            super.writeMessageEnd();
        }
        finally {
            Span span = this.spanHolder.getSpan();
            if (span != null && this.oneWay && this.finishSpan) {
                span.finish();
                this.spanHolder.setSpan(null);
            }
        }
    }

    public void writeFieldStop() throws TException {
        Span span;
        if (!this.injected && (span = this.spanHolder.getSpan()) != null) {
            HashMap map = new HashMap();
            this.tracer.inject(span.context(), Format.Builtin.TEXT_MAP, (Object)new TextMapAdapter(map));
            super.writeFieldBegin(new TField("span", 13, 3333));
            super.writeMapBegin(new TMap(11, 11, map.size()));
            for (Map.Entry entry : map.entrySet()) {
                super.writeString((String)entry.getKey());
                super.writeString((String)entry.getValue());
            }
            super.writeMapEnd();
            super.writeFieldEnd();
            this.injected = true;
        }
        super.writeFieldStop();
    }

    public TMessage readMessageBegin() throws TException {
        try {
            return super.readMessageBegin();
        }
        catch (TTransportException tte) {
            Span span = this.spanHolder.getSpan();
            if (span != null) {
                this.spanDecorator.onError(tte, span);
                if (this.finishSpan) {
                    span.finish();
                    this.spanHolder.setSpan(null);
                }
            }
            throw tte;
        }
    }

    public void readMessageEnd() throws TException {
        try {
            super.readMessageEnd();
        }
        finally {
            Span span = this.spanHolder.getSpan();
            if (span != null && this.finishSpan) {
                span.finish();
                this.spanHolder.setSpan(null);
            }
        }
    }

    public static class Factory
    implements TProtocolFactory {
        private final TProtocolFactory delegate;
        private final SpanHolder spanHolder = new SpanHolder();
        private final Tracer tracer;
        private final boolean finishSpan;

        public Factory(TProtocolFactory delegate, Tracer tracer, boolean finishSpan) {
            this.delegate = delegate;
            this.tracer = tracer;
            this.finishSpan = finishSpan;
        }

        public TProtocol getProtocol(TTransport trans) {
            return new SpanProtocol(this.delegate.getProtocol(trans), this.tracer, this.spanHolder, this.finishSpan);
        }

        SpanHolder getSpanHolder() {
            return this.spanHolder;
        }

        Tracer getTracer() {
            return this.tracer;
        }
    }
}

