/*
 * Decompiled with CFR 0.152.
 */
package io.opentracing.thrift;

import io.opentracing.Scope;
import io.opentracing.Span;
import io.opentracing.Tracer;
import io.opentracing.thrift.SpanDecorator;
import io.opentracing.thrift.SpanHolder;
import io.opentracing.thrift.SpanProtocol;
import org.apache.thrift.async.AsyncMethodCallback;

public class TracingAsyncMethodCallback<T>
implements AsyncMethodCallback<T> {
    private final AsyncMethodCallback<T> callback;
    private final SpanHolder spanHolder;
    private final Tracer tracer;

    public TracingAsyncMethodCallback(AsyncMethodCallback<T> callback, SpanProtocol.Factory factory) {
        this.callback = callback;
        this.spanHolder = factory.getSpanHolder();
        this.tracer = factory.getTracer();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete(T response) {
        Span span = this.spanHolder.getSpan();
        Scope scope = null;
        if (span != null) {
            scope = this.tracer.scopeManager().activate(span);
        }
        try {
            this.callback.onComplete(response);
        }
        finally {
            if (scope != null) {
                scope.close();
                span.finish();
                this.spanHolder.clear();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Exception exception) {
        Span span = this.spanHolder.getSpan();
        Scope scope = null;
        if (span != null) {
            scope = this.tracer.scopeManager().activate(span);
        }
        try {
            this.callback.onError(exception);
        }
        finally {
            if (scope != null) {
                SpanDecorator.onError(exception, span);
                scope.close();
                span.finish();
                this.spanHolder.clear();
            }
        }
    }
}

