/*
 * Decompiled with CFR 0.152.
 */
package io.pinecone;

import io.pinecone.exceptions.FailedRequestInfo;
import io.pinecone.exceptions.HttpErrorMapper;
import io.pinecone.exceptions.PineconeException;
import io.pinecone.exceptions.PineconeValidationException;
import okhttp3.OkHttpClient;
import org.openapitools.client.ApiClient;
import org.openapitools.client.ApiException;
import org.openapitools.client.api.ManageIndexesApi;
import org.openapitools.client.model.CollectionList;
import org.openapitools.client.model.CollectionModel;
import org.openapitools.client.model.ConfigureIndexRequest;
import org.openapitools.client.model.CreateCollectionRequest;
import org.openapitools.client.model.CreateIndexRequest;
import org.openapitools.client.model.IndexList;
import org.openapitools.client.model.IndexModel;

public class PineconeControlPlaneClient {
    private ManageIndexesApi manageIndexesApi;

    public PineconeControlPlaneClient(String apiKey) {
        this(apiKey, new OkHttpClient());
    }

    public PineconeControlPlaneClient(String apiKey, OkHttpClient okHttpClient) {
        if (apiKey == null || apiKey.isEmpty()) {
            throw new PineconeValidationException("The API key is required and must not be empty or null");
        }
        ApiClient apiClient = new ApiClient(okHttpClient);
        apiClient.setApiKey(apiKey);
        this.manageIndexesApi = new ManageIndexesApi();
        this.manageIndexesApi.setApiClient(apiClient);
    }

    public IndexModel createIndex(CreateIndexRequest createIndexRequest) throws PineconeException {
        IndexModel indexModel = new IndexModel();
        try {
            indexModel = this.manageIndexesApi.createIndex(createIndexRequest);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return indexModel;
    }

    public IndexModel describeIndex(String indexName) throws PineconeException {
        IndexModel indexModel = new IndexModel();
        try {
            indexModel = this.manageIndexesApi.describeIndex(indexName);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return indexModel;
    }

    public void configureIndex(String indexName, ConfigureIndexRequest configureIndexRequest) throws PineconeException {
        try {
            this.manageIndexesApi.configureIndex(indexName, configureIndexRequest);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
    }

    public IndexList listIndexes() throws PineconeException {
        IndexList indexList = new IndexList();
        try {
            indexList = this.manageIndexesApi.listIndexes();
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return indexList;
    }

    public void deleteIndex(String indexName) throws PineconeException {
        try {
            this.manageIndexesApi.deleteIndex(indexName);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
    }

    public CollectionModel createCollection(CreateCollectionRequest createCollectionRequest) throws PineconeException {
        CollectionModel collection = null;
        try {
            collection = this.manageIndexesApi.createCollection(createCollectionRequest);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return collection;
    }

    public CollectionModel describeCollection(String collectionName) throws PineconeException {
        CollectionModel collection = null;
        try {
            collection = this.manageIndexesApi.describeCollection(collectionName);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return collection;
    }

    public CollectionList listCollections() throws PineconeException {
        CollectionList collections = null;
        try {
            collections = this.manageIndexesApi.listCollections();
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
        return collections;
    }

    public void deleteCollection(String collectionName) throws PineconeException {
        try {
            this.manageIndexesApi.deleteCollection(collectionName);
        }
        catch (ApiException apiException) {
            this.handleApiException(apiException);
        }
    }

    private void handleApiException(ApiException apiException) throws PineconeException {
        int statusCode = apiException.getCode();
        String responseBody = apiException.getResponseBody();
        FailedRequestInfo failedRequestInfo = new FailedRequestInfo(statusCode, responseBody);
        HttpErrorMapper.mapHttpStatusError(failedRequestInfo);
    }
}

