/*
 * Decompiled with CFR 0.152.
 */
package org.openapitools.client.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.openapitools.client.JSON;
import org.openapitools.client.model.IndexMetric;
import org.openapitools.client.model.IndexModelSpec;
import org.openapitools.client.model.IndexModelStatus;

public class IndexModel {
    public static final String SERIALIZED_NAME_NAME = "name";
    @SerializedName(value="name")
    private String name;
    public static final String SERIALIZED_NAME_DIMENSION = "dimension";
    @SerializedName(value="dimension")
    private Integer dimension;
    public static final String SERIALIZED_NAME_METRIC = "metric";
    @SerializedName(value="metric")
    private IndexMetric metric = IndexMetric.COSINE;
    public static final String SERIALIZED_NAME_HOST = "host";
    @SerializedName(value="host")
    private String host;
    public static final String SERIALIZED_NAME_SPEC = "spec";
    @SerializedName(value="spec")
    private IndexModelSpec spec;
    public static final String SERIALIZED_NAME_STATUS = "status";
    @SerializedName(value="status")
    private IndexModelStatus status;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public IndexModel name(String name) {
        this.name = name;
        return this;
    }

    @Nonnull
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public IndexModel dimension(Integer dimension) {
        this.dimension = dimension;
        return this;
    }

    @Nonnull
    public Integer getDimension() {
        return this.dimension;
    }

    public void setDimension(Integer dimension) {
        this.dimension = dimension;
    }

    public IndexModel metric(IndexMetric metric) {
        this.metric = metric;
        return this;
    }

    @Nonnull
    public IndexMetric getMetric() {
        return this.metric;
    }

    public void setMetric(IndexMetric metric) {
        this.metric = metric;
    }

    public IndexModel host(String host) {
        this.host = host;
        return this;
    }

    @Nullable
    public String getHost() {
        return this.host;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public IndexModel spec(IndexModelSpec spec) {
        this.spec = spec;
        return this;
    }

    @Nonnull
    public IndexModelSpec getSpec() {
        return this.spec;
    }

    public void setSpec(IndexModelSpec spec) {
        this.spec = spec;
    }

    public IndexModel status(IndexModelStatus status) {
        this.status = status;
        return this;
    }

    @Nonnull
    public IndexModelStatus getStatus() {
        return this.status;
    }

    public void setStatus(IndexModelStatus status) {
        this.status = status;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        IndexModel indexModel = (IndexModel)o;
        return Objects.equals(this.name, indexModel.name) && Objects.equals(this.dimension, indexModel.dimension) && Objects.equals((Object)this.metric, (Object)indexModel.metric) && Objects.equals(this.host, indexModel.host) && Objects.equals(this.spec, indexModel.spec) && Objects.equals(this.status, indexModel.status);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.dimension, this.metric, this.host, this.spec, this.status});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class IndexModel {\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    dimension: ").append(this.toIndentedString(this.dimension)).append("\n");
        sb.append("    metric: ").append(this.toIndentedString((Object)this.metric)).append("\n");
        sb.append("    host: ").append(this.toIndentedString(this.host)).append("\n");
        sb.append("    spec: ").append(this.toIndentedString(this.spec)).append("\n");
        sb.append("    status: ").append(this.toIndentedString(this.status)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonElement(JsonElement jsonElement) throws IOException {
        if (jsonElement == null && !openapiRequiredFields.isEmpty()) {
            throw new IllegalArgumentException(String.format("The required field(s) %s in IndexModel is not found in the empty JSON string", openapiRequiredFields.toString()));
        }
        Set entries = jsonElement.getAsJsonObject().entrySet();
        for (Map.Entry entry : entries) {
            if (openapiFields.contains(entry.getKey())) continue;
            throw new IllegalArgumentException(String.format("The field `%s` in the JSON string is not defined in the `IndexModel` properties. JSON: %s", entry.getKey(), jsonElement.toString()));
        }
        for (String requiredField : openapiRequiredFields) {
            if (jsonElement.getAsJsonObject().get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonElement.toString()));
        }
        JsonObject jsonObj = jsonElement.getAsJsonObject();
        if (!jsonObj.get(SERIALIZED_NAME_NAME).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `name` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_NAME).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_HOST) != null && !jsonObj.get(SERIALIZED_NAME_HOST).isJsonNull() && !jsonObj.get(SERIALIZED_NAME_HOST).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `host` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_HOST).toString()));
        }
        IndexModelSpec.validateJsonElement(jsonObj.get(SERIALIZED_NAME_SPEC));
        IndexModelStatus.validateJsonElement(jsonObj.get(SERIALIZED_NAME_STATUS));
    }

    public static IndexModel fromJson(String jsonString) throws IOException {
        return (IndexModel)JSON.getGson().fromJson(jsonString, IndexModel.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_NAME);
        openapiFields.add(SERIALIZED_NAME_DIMENSION);
        openapiFields.add(SERIALIZED_NAME_METRIC);
        openapiFields.add(SERIALIZED_NAME_HOST);
        openapiFields.add(SERIALIZED_NAME_SPEC);
        openapiFields.add(SERIALIZED_NAME_STATUS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_NAME);
        openapiRequiredFields.add(SERIALIZED_NAME_DIMENSION);
        openapiRequiredFields.add(SERIALIZED_NAME_METRIC);
        openapiRequiredFields.add(SERIALIZED_NAME_SPEC);
        openapiRequiredFields.add(SERIALIZED_NAME_STATUS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!IndexModel.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(IndexModel.class));
            return new TypeAdapter<IndexModel>(){

                public void write(JsonWriter out, IndexModel value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public IndexModel read(JsonReader in) throws IOException {
                    JsonElement jsonElement = (JsonElement)elementAdapter.read(in);
                    IndexModel.validateJsonElement(jsonElement);
                    return (IndexModel)thisAdapter.fromJsonTree(jsonElement);
                }
            }.nullSafe();
        }
    }
}

