/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.config.client;

import io.pivotal.cfenv.core.CfCredentials;
import io.pivotal.cfenv.core.CfEnv;
import io.pivotal.cfenv.core.CfService;
import java.util.HashMap;
import java.util.List;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;

public class ConfigClientEnvironmentPostProcessor
implements EnvironmentPostProcessor,
Ordered {
    private static final String SPRING_CLOUD_SERVICES_CONFIG_IMPORT = "springCloudServicesConfigImport";

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        CfEnv cfEnv = new CfEnv();
        List configServices = cfEnv.findServicesByTag(new String[]{"configuration"});
        if (configServices.size() != 1) {
            return;
        }
        CfCredentials credentials = ((CfService)configServices.stream().findFirst().get()).getCredentials();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("spring.config.import", "optional:configserver:" + credentials.getUri(new String[0]));
        map.put("spring.cloud.refresh.additional-property-sources-to-retain", SPRING_CLOUD_SERVICES_CONFIG_IMPORT);
        environment.getPropertySources().addFirst((PropertySource)new MapPropertySource(SPRING_CLOUD_SERVICES_CONFIG_IMPORT, map));
    }

    public int getOrder() {
        return -2147483639;
    }
}

