/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.service.registry;

import java.util.logging.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.boot.context.properties.bind.Binder;
import org.springframework.cloud.commons.util.InetUtils;
import org.springframework.cloud.netflix.eureka.EurekaInstanceConfigBean;
import org.springframework.core.env.Environment;
import org.springframework.util.StringUtils;

final class SanitizingEurekaInstanceConfigBean
extends EurekaInstanceConfigBean
implements InitializingBean {
    private static final Logger LOGGER = Logger.getLogger(SanitizingEurekaInstanceConfigBean.class.getName());

    public SanitizingEurekaInstanceConfigBean(InetUtils inetUtils) {
        super(inetUtils);
    }

    public void setEnvironment(Environment environment) {
        super.setEnvironment(environment);
        String springAppName = this.getSpringApplicationName();
        String eurekaInstanceAppname = this.getEurekaInstanceAppnameProperty();
        if (StringUtils.hasText((String)eurekaInstanceAppname)) {
            this.setVirtualHostName(eurekaInstanceAppname);
            this.setSecureVirtualHostName(eurekaInstanceAppname);
        } else if (StringUtils.hasText((String)springAppName)) {
            String sanitizedAppName = this.sanitizeHostname(springAppName);
            if (!springAppName.equals(sanitizedAppName)) {
                LOGGER.warning("Spring application name '" + springAppName + "' was sanitized to produce eureka.instance.appname '" + sanitizedAppName + "'");
            }
            this.setAppname(sanitizedAppName);
            this.setVirtualHostName(sanitizedAppName);
            this.setSecureVirtualHostName(sanitizedAppName);
        }
    }

    private String getSpringApplicationName() {
        return (String)Binder.get((Environment)this.getEnvironment()).bind("spring.application.name", String.class).orElse(null);
    }

    private String getEurekaInstanceAppnameProperty() {
        return (String)Binder.get((Environment)this.getEnvironment()).bind("eureka.instance.appname", String.class).orElse(null);
    }

    private String sanitizeHostname(String hostname) {
        if (hostname == null) {
            return null;
        }
        return hostname.replaceAll("[^0-9a-zA-Z\\-\\.]", "-");
    }

    public void afterPropertiesSet() {
        String messageSuffix = "' is set to a different value than eureka.instance.appname '" + this.getAppname() + "', and is disallowed in Spring Cloud Services. Try only setting eureka.instance.appname. Please refer to our documentation and reach out to us if you think you require different values.";
        if (StringUtils.hasText((String)this.getVirtualHostName()) && !this.getVirtualHostName().equalsIgnoreCase(this.getAppname())) {
            throw new IllegalArgumentException("eureka.instance.virtualHostName '" + this.getVirtualHostName() + messageSuffix);
        }
        if (StringUtils.hasText((String)this.getSecureVirtualHostName()) && !this.getSecureVirtualHostName().equalsIgnoreCase(this.getAppname())) {
            throw new IllegalArgumentException("eureka.instance.secureVirtualHostName '" + this.getSecureVirtualHostName() + messageSuffix);
        }
    }
}

