/*
 * Decompiled with CFR 0.152.
 */
package io.pivotal.spring.cloud.service.registry;

import com.netflix.discovery.shared.resolver.EurekaEndpoint;
import com.netflix.discovery.shared.transport.EurekaHttpClient;
import io.pivotal.spring.cloud.service.registry.OAuth2AuthorizedClientHttpRequestInterceptor;
import org.springframework.cloud.netflix.eureka.http.RestTemplateEurekaHttpClient;
import org.springframework.cloud.netflix.eureka.http.RestTemplateTransportClientFactory;
import org.springframework.http.HttpStatus;
import org.springframework.security.oauth2.client.registration.ClientRegistration;
import org.springframework.web.client.DefaultResponseErrorHandler;
import org.springframework.web.client.ResponseErrorHandler;
import org.springframework.web.client.RestTemplate;

public class OAuth2TransportClientFactory
extends RestTemplateTransportClientFactory {
    private final ClientRegistration clientRegistration;

    public OAuth2TransportClientFactory(ClientRegistration clientRegistration) {
        this.clientRegistration = clientRegistration;
    }

    public EurekaHttpClient newClient(EurekaEndpoint serviceUrl) {
        return new RestTemplateEurekaHttpClient(this.restTemplate(serviceUrl.getServiceUrl()), serviceUrl.getServiceUrl());
    }

    private RestTemplate restTemplate(String serviceUrl) {
        RestTemplate restTemplate = new RestTemplate();
        restTemplate.getInterceptors().add(new OAuth2AuthorizedClientHttpRequestInterceptor(this.clientRegistration));
        restTemplate.getMessageConverters().add(0, this.mappingJacksonHttpMessageConverter());
        restTemplate.setErrorHandler((ResponseErrorHandler)new ErrorHandler());
        return restTemplate;
    }

    class ErrorHandler
    extends DefaultResponseErrorHandler {
        ErrorHandler() {
        }

        protected boolean hasError(HttpStatus statusCode) {
            if (statusCode.is4xxClientError()) {
                return false;
            }
            return super.hasError(statusCode);
        }
    }
}

