/*
 * Decompiled with CFR 0.152.
 */
package playn.java;

import javax.sound.sampled.AudioFormat;
import javax.sound.sampled.AudioInputStream;
import javax.sound.sampled.AudioSystem;
import javax.sound.sampled.Clip;
import javax.sound.sampled.DataLine;
import playn.core.Audio;
import playn.core.Exec;
import playn.java.BigClip;
import playn.java.JavaAssets;
import playn.java.JavaSound;

public class JavaAudio
extends Audio {
    private final Exec exec;

    public JavaAudio(Exec exec) {
        this.exec = exec;
    }

    public JavaSound createSound(final JavaAssets.Resource rsrc, final boolean music) {
        final JavaSound sound = new JavaSound(this.exec);
        this.exec.invokeAsync(new Runnable(){

            @Override
            public void run() {
                try {
                    Clip clip;
                    AudioInputStream ais = rsrc.openAudioStream();
                    AudioFormat format = ais.getFormat();
                    if (music) {
                        if (format.getEncoding() != AudioFormat.Encoding.PCM_SIGNED) {
                            ais = AudioSystem.getAudioInputStream(new AudioFormat(AudioFormat.Encoding.PCM_SIGNED, format.getSampleRate(), 16, format.getChannels(), format.getChannels() * 2, format.getSampleRate(), false), ais);
                        }
                        clip = new BigClip();
                    } else {
                        DataLine.Info info = new DataLine.Info(Clip.class, format);
                        clip = (Clip)AudioSystem.getLine(info);
                    }
                    clip.open(ais);
                    sound.succeed(clip);
                }
                catch (Exception e) {
                    sound.fail(e);
                }
            }
        });
        return sound;
    }
}

