/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.receiver;

import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.config.ConfigException;
import reactor.kafka.receiver.ReceiverPartition;

public class ReceiverOptions<K, V> {
    private static final Duration DEFAULT_POLL_TIMEOUT = Duration.ofMillis(100L);
    private static final int DEFAULT_MAX_COMMIT_ATTEMPTS = 100;
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private final List<java.util.function.Consumer<Collection<ReceiverPartition>>> assignListeners = new ArrayList<java.util.function.Consumer<Collection<ReceiverPartition>>>();
    private final List<java.util.function.Consumer<Collection<ReceiverPartition>>> revokeListeners = new ArrayList<java.util.function.Consumer<Collection<ReceiverPartition>>>();
    private Duration pollTimeout = DEFAULT_POLL_TIMEOUT;
    private Duration closeTimeout = Duration.ofNanos(Long.MAX_VALUE);
    private Duration commitInterval = Duration.ofMillis(5000L);
    private int commitBatchSize = 0;
    private int atmostOnceCommitAheadSize;
    private int maxCommitAttempts = 100;
    private Collection<String> subscribeTopics;
    private Collection<TopicPartition> assignTopicPartitions;
    private Pattern subscribePattern;

    public static <K, V> ReceiverOptions<K, V> create() {
        return new ReceiverOptions<K, V>();
    }

    public static <K, V> ReceiverOptions<K, V> create(Map<String, Object> configProperties) {
        ReceiverOptions<K, V> options = ReceiverOptions.create();
        options.properties.putAll(configProperties);
        return options;
    }

    public static <K, V> ReceiverOptions<K, V> create(Properties configProperties) {
        ReceiverOptions<K, V> options = ReceiverOptions.create();
        configProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(name, value) -> options.properties.put((String)name, value)));
        return options;
    }

    private ReceiverOptions() {
        this.properties.put("enable.auto.commit", "false");
    }

    public Map<String, Object> consumerProperties() {
        return this.properties;
    }

    public Object consumerProperty(String name) {
        return this.properties.get(name);
    }

    public ReceiverOptions<K, V> consumerProperty(String name, Object newValue) {
        this.properties.put(name, newValue);
        return this;
    }

    public Duration pollTimeout() {
        return this.pollTimeout;
    }

    public ReceiverOptions<K, V> pollTimeout(Duration timeout) {
        this.pollTimeout = timeout;
        return this;
    }

    public Duration closeTimeout() {
        return this.closeTimeout;
    }

    public ReceiverOptions<K, V> closeTimeout(Duration timeout) {
        this.closeTimeout = timeout;
        return this;
    }

    public ReceiverOptions<K, V> addAssignListener(java.util.function.Consumer<Collection<ReceiverPartition>> onAssign) {
        this.assignListeners.add(onAssign);
        return this;
    }

    public ReceiverOptions<K, V> addRevokeListener(java.util.function.Consumer<Collection<ReceiverPartition>> onRevoke) {
        this.revokeListeners.add(onRevoke);
        return this;
    }

    public ReceiverOptions<K, V> clearAssignListeners() {
        this.assignListeners.clear();
        return this;
    }

    public ReceiverOptions<K, V> clearRevokeListeners() {
        this.revokeListeners.clear();
        return this;
    }

    public List<java.util.function.Consumer<Collection<ReceiverPartition>>> assignListeners() {
        return this.assignListeners;
    }

    public List<java.util.function.Consumer<Collection<ReceiverPartition>>> revokeListeners() {
        return this.revokeListeners;
    }

    public ReceiverOptions<K, V> subscription(Collection<String> topics) {
        this.subscribeTopics = new ArrayList<String>(topics);
        this.subscribePattern = null;
        this.assignTopicPartitions = null;
        return this;
    }

    public ReceiverOptions<K, V> subscription(Pattern pattern) {
        this.subscribeTopics = null;
        this.subscribePattern = pattern;
        this.assignTopicPartitions = null;
        return this;
    }

    public ReceiverOptions<K, V> assignment(Collection<TopicPartition> partitions) {
        this.subscribeTopics = null;
        this.subscribePattern = null;
        this.assignTopicPartitions = new ArrayList<TopicPartition>(partitions);
        return this;
    }

    public Collection<TopicPartition> assignment() {
        return this.assignTopicPartitions;
    }

    public java.util.function.Consumer<Consumer<K, V>> subscriber(ConsumerRebalanceListener listener) {
        if (this.subscribeTopics != null) {
            return consumer -> consumer.subscribe(this.subscribeTopics, listener);
        }
        if (this.subscribePattern != null) {
            return consumer -> consumer.subscribe(this.subscribePattern, listener);
        }
        if (this.assignTopicPartitions != null) {
            return consumer -> {
                consumer.assign(this.assignTopicPartitions);
                listener.onPartitionsAssigned(this.assignTopicPartitions);
            };
        }
        throw new IllegalStateException("No subscriptions have been created");
    }

    public String groupId() {
        return (String)this.consumerProperty("group.id");
    }

    public Duration heartbeatInterval() {
        long defaultValue = 3000L;
        long heartbeatIntervalMs = this.getLongOption("heartbeat.interval.ms", defaultValue);
        return Duration.ofMillis(heartbeatIntervalMs);
    }

    public Duration commitInterval() {
        return this.commitInterval;
    }

    public ReceiverOptions<K, V> commitInterval(Duration commitInterval) {
        if (commitInterval == null || commitInterval.isNegative()) {
            throw new IllegalArgumentException("Commit interval must be >= 0");
        }
        this.commitInterval = commitInterval;
        return this;
    }

    public int commitBatchSize() {
        return this.commitBatchSize;
    }

    public ReceiverOptions<K, V> commitBatchSize(int commitBatchSize) {
        if (commitBatchSize < 0) {
            throw new IllegalArgumentException("Commit batch size must be >= 0");
        }
        this.commitBatchSize = commitBatchSize;
        return this;
    }

    public int atmostOnceCommitAheadSize() {
        return this.atmostOnceCommitAheadSize;
    }

    public ReceiverOptions<K, V> atmostOnceCommitAheadSize(int commitAheadSize) {
        if (commitAheadSize < 0) {
            throw new IllegalArgumentException("Commit ahead size must be >= 0");
        }
        this.atmostOnceCommitAheadSize = commitAheadSize;
        return this;
    }

    public int maxCommitAttempts() {
        return this.maxCommitAttempts;
    }

    public ReceiverOptions<K, V> maxCommitAttempts(int maxAttempts) {
        this.maxCommitAttempts = maxAttempts;
        return this;
    }

    public ReceiverOptions<K, V> toImmutable() {
        ReceiverOptions options = new ReceiverOptions<K, V>(){

            @Override
            public Map<String, Object> consumerProperties() {
                return Collections.unmodifiableMap(((ReceiverOptions)this).properties);
            }

            @Override
            public ReceiverOptions<K, V> consumerProperty(String name, Object newValue) {
                throw new UnsupportedOperationException("Cannot modify immutable options");
            }

            @Override
            public ReceiverOptions<K, V> addAssignListener(java.util.function.Consumer<Collection<ReceiverPartition>> onAssign) {
                throw new UnsupportedOperationException("Cannot modify immutable options");
            }

            @Override
            public ReceiverOptions<K, V> addRevokeListener(java.util.function.Consumer<Collection<ReceiverPartition>> onRevoke) {
                throw new UnsupportedOperationException("Cannot modify immutable options");
            }

            @Override
            public ReceiverOptions<K, V> subscription(Collection<String> topics) {
                throw new UnsupportedOperationException("Cannot modify immutable options");
            }

            @Override
            public ReceiverOptions<K, V> subscription(Pattern pattern) {
                throw new UnsupportedOperationException("Cannot modify immutable options");
            }

            @Override
            public ReceiverOptions<K, V> assignment(Collection<TopicPartition> partitions) {
                throw new UnsupportedOperationException("Cannot modify immutable options");
            }

            @Override
            public ReceiverOptions<K, V> pollTimeout(Duration timeout) {
                throw new UnsupportedOperationException("Cannot modify immutable options");
            }

            @Override
            public ReceiverOptions<K, V> closeTimeout(Duration timeout) {
                throw new UnsupportedOperationException("Cannot modify immutable options");
            }

            @Override
            public ReceiverOptions<K, V> commitInterval(Duration interval) {
                throw new UnsupportedOperationException("Cannot modify immutable options");
            }

            @Override
            public ReceiverOptions<K, V> commitBatchSize(int commitBatchSize) {
                throw new UnsupportedOperationException("Cannot modify immutable options");
            }

            @Override
            public ReceiverOptions<K, V> atmostOnceCommitAheadSize(int commitAheadSize) {
                throw new UnsupportedOperationException("Cannot modify immutable options");
            }

            @Override
            public ReceiverOptions<K, V> maxCommitAttempts(int maxRetries) {
                throw new UnsupportedOperationException("Cannot modify immutable options");
            }
        };
        options.properties.putAll(this.properties);
        options.assignListeners.addAll(this.assignListeners);
        options.revokeListeners.addAll(this.revokeListeners);
        if (this.subscribeTopics != null) {
            options.subscribeTopics = new ArrayList<String>(this.subscribeTopics);
        }
        if (this.assignTopicPartitions != null) {
            options.assignTopicPartitions = new ArrayList<TopicPartition>(this.assignTopicPartitions);
        }
        options.subscribePattern = this.subscribePattern;
        options.pollTimeout = this.pollTimeout;
        options.closeTimeout = this.closeTimeout;
        options.commitInterval = this.commitInterval;
        options.commitBatchSize = this.commitBatchSize;
        options.atmostOnceCommitAheadSize = this.atmostOnceCommitAheadSize;
        options.maxCommitAttempts = this.maxCommitAttempts;
        return options;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private long getLongOption(String optionName, long defaultValue) {
        Object value = this.consumerProperty(optionName);
        long optionValue = 0L;
        if (value == null) return defaultValue;
        if (value instanceof Long) {
            return (Long)value;
        }
        if (!(value instanceof String)) throw new ConfigException("Invalid value " + value);
        return Long.parseLong((String)value);
    }
}

