/*
 * Decompiled with CFR 0.152.
 */
package reactor.kafka.sender;

import java.time.Duration;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.function.BiConsumer;
import javax.naming.AuthenticationException;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.ProducerFencedException;
import reactor.core.scheduler.Scheduler;
import reactor.core.scheduler.Schedulers;
import reactor.util.concurrent.Queues;

public class SenderOptions<K, V> {
    private final Map<String, Object> properties = new HashMap<String, Object>();
    private Duration closeTimeout = Duration.ofMillis(Long.MAX_VALUE);
    private Scheduler scheduler = null;
    private int maxInFlight = Queues.SMALL_BUFFER_SIZE;
    private boolean stopOnError = true;

    public static <K, V> SenderOptions<K, V> create() {
        return new SenderOptions<K, V>();
    }

    public static <K, V> SenderOptions<K, V> create(Map<String, Object> configProperties) {
        SenderOptions<K, V> options = SenderOptions.create();
        options.properties.putAll(configProperties);
        return options;
    }

    public static <K, V> SenderOptions<K, V> create(Properties configProperties) {
        SenderOptions<K, V> options = SenderOptions.create();
        configProperties.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(name, value) -> options.properties.put((String)name, value)));
        return options;
    }

    private SenderOptions() {
    }

    public Map<String, Object> producerProperties() {
        return this.properties;
    }

    public Object producerProperty(String name) {
        return this.properties.get(name);
    }

    public SenderOptions<K, V> producerProperty(String name, Object value) {
        this.properties.put(name, value);
        return this;
    }

    public Scheduler scheduler() {
        return this.scheduler;
    }

    public SenderOptions<K, V> scheduler(Scheduler scheduler) {
        this.scheduler = scheduler;
        return this;
    }

    public int maxInFlight() {
        return this.maxInFlight;
    }

    public SenderOptions<K, V> maxInFlight(int maxInFlight) {
        this.maxInFlight = maxInFlight;
        return this;
    }

    public boolean stopOnError() {
        return this.stopOnError;
    }

    public SenderOptions<K, V> stopOnError(boolean stopOnError) {
        this.stopOnError = stopOnError;
        return this;
    }

    public Duration closeTimeout() {
        return this.closeTimeout;
    }

    public SenderOptions<K, V> closeTimeout(Duration timeout) {
        this.closeTimeout = timeout;
        return this;
    }

    public boolean isTransactional() {
        String transactionalId = this.transactionalId();
        return transactionalId != null && !transactionalId.isEmpty();
    }

    public String transactionalId() {
        return (String)this.properties.get("transactional.id");
    }

    public boolean fatalException(Throwable t) {
        return t instanceof AuthenticationException || t instanceof ProducerFencedException;
    }

    void validate() {
        if (this.isTransactional()) {
            if (!this.stopOnError) {
                throw new ConfigException("Transactional senders must be created with stopOnError=true");
            }
            if (this.scheduler != null) {
                throw new ConfigException("Scheduler cannot be overridden for transactional senders");
            }
        }
    }

    public SenderOptions<K, V> toImmutable() {
        this.validate();
        SenderOptions options = new SenderOptions<K, V>(){

            @Override
            public Map<String, Object> producerProperties() {
                return Collections.unmodifiableMap(((SenderOptions)this).properties);
            }

            @Override
            public SenderOptions<K, V> producerProperty(String name, Object value) {
                throw new UnsupportedOperationException("Cannot modify immutable options");
            }

            @Override
            public SenderOptions<K, V> scheduler(Scheduler scheduler) {
                throw new UnsupportedOperationException("Cannot modify immutable options");
            }

            @Override
            public SenderOptions<K, V> maxInFlight(int maxInFlight) {
                throw new UnsupportedOperationException("Cannot modify immutable options");
            }

            @Override
            public SenderOptions<K, V> stopOnError(boolean stopOnError) {
                throw new UnsupportedOperationException("Cannot modify immutable options");
            }

            @Override
            public SenderOptions<K, V> closeTimeout(Duration timeout) {
                throw new UnsupportedOperationException("Cannot modify immutable options");
            }
        };
        options.properties.putAll(this.properties);
        options.closeTimeout = this.closeTimeout;
        String transactionalId = this.transactionalId();
        options.scheduler = transactionalId != null ? Schedulers.newSingle((String)transactionalId) : (this.scheduler == null ? Schedulers.single() : this.scheduler);
        options.maxInFlight = this.maxInFlight;
        options.stopOnError = this.stopOnError;
        return options;
    }
}

