/*
 * Decompiled with CFR 0.152.
 */
package reactor.io.net;

import java.net.InetSocketAddress;
import reactor.Environment;
import reactor.core.Dispatcher;
import reactor.fn.tuple.Tuple2;
import reactor.io.buffer.Buffer;
import reactor.io.codec.Codec;
import reactor.io.net.ChannelStream;
import reactor.io.net.ReactorChannelHandler;
import reactor.io.net.ReactorPeer;
import reactor.io.net.Reconnect;
import reactor.rx.Stream;
import reactor.rx.Streams;

public abstract class ReactorClient<IN, OUT, CONN extends ChannelStream<IN, OUT>>
extends ReactorPeer<IN, OUT, CONN> {
    public static final ReactorChannelHandler PING = new ReactorChannelHandler(){

        public Object apply(Object o) {
            return Streams.empty();
        }
    };

    protected ReactorClient(Environment defaultEnv, Dispatcher defaultDispatcher, Codec<Buffer, IN, OUT> codec, long prefetch) {
        super(defaultEnv, defaultDispatcher, codec, prefetch);
    }

    public final Stream<Tuple2<InetSocketAddress, Integer>> start(ReactorChannelHandler<IN, OUT, CONN> handler, Reconnect reconnect) {
        if (!this.started.compareAndSet(false, true)) {
            throw new IllegalStateException("Client already started");
        }
        return this.doStart(handler, reconnect);
    }

    protected abstract Stream<Tuple2<InetSocketAddress, Integer>> doStart(ReactorChannelHandler<IN, OUT, CONN> var1, Reconnect var2);
}

