/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.api.trace.propagation.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.api.internal.Utils;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.api.trace.TraceState;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.api.trace.TraceStateBuilder;
import java.util.regex.Pattern;
import javax.annotation.concurrent.Immutable;

@Immutable
public final class W3CTraceContextEncoding {
    private static final int TRACESTATE_MAX_SIZE = 512;
    private static final int TRACESTATE_MAX_MEMBERS = 32;
    private static final char TRACESTATE_KEY_VALUE_DELIMITER = '=';
    private static final char TRACESTATE_ENTRY_DELIMITER = ',';
    private static final Pattern TRACESTATE_ENTRY_DELIMITER_SPLIT_PATTERN = Pattern.compile("[ \t]*,[ \t]*");

    private W3CTraceContextEncoding() {
    }

    public static TraceState decodeTraceState(String traceStateHeader) {
        TraceStateBuilder traceStateBuilder = TraceState.builder();
        String[] listMembers = TRACESTATE_ENTRY_DELIMITER_SPLIT_PATTERN.split(traceStateHeader);
        Utils.checkArgument(listMembers.length <= 32, "TraceState has too many elements.");
        for (int i = listMembers.length - 1; i >= 0; --i) {
            String listMember = listMembers[i];
            int index = listMember.indexOf(61);
            Utils.checkArgument(index != -1, "Invalid TraceState list-member format.");
            traceStateBuilder.put(listMember.substring(0, index), listMember.substring(index + 1));
        }
        TraceState traceState = traceStateBuilder.build();
        if (traceState.size() != listMembers.length) {
            return TraceState.getDefault();
        }
        return traceState;
    }

    public static String encodeTraceState(TraceState traceState) {
        if (traceState.isEmpty()) {
            return "";
        }
        StringBuilder builder = new StringBuilder(512);
        traceState.forEach((key, value) -> {
            if (builder.length() != 0) {
                builder.append(',');
            }
            builder.append((String)key).append('=').append((String)value);
        });
        return builder.toString();
    }
}

