/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.sender.okhttp.internal;

import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.internal.compression.Compressor;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.exporter.internal.marshal.Marshaler;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.okhttp3.MediaType;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.okhttp3.RequestBody;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.okio.Buffer;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.okio.BufferedSink;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.okio.Okio;
import java.io.IOException;
import javax.annotation.Nullable;

public final class GrpcRequestBody
extends RequestBody {
    private static final int HEADER_LENGTH = 5;
    private static final byte UNCOMPRESSED_FLAG = 0;
    private static final byte COMPRESSED_FLAG = 1;
    private static final MediaType GRPC_MEDIA_TYPE = MediaType.parse("application/grpc");
    private final Marshaler marshaler;
    private final int messageSize;
    private final int contentLength;
    @Nullable
    private final Compressor compressor;

    public GrpcRequestBody(Marshaler marshaler, @Nullable Compressor compressor) {
        this.marshaler = marshaler;
        this.compressor = compressor;
        this.messageSize = marshaler.getBinarySerializedSize();
        this.contentLength = compressor != null ? -1 : 5 + this.messageSize;
    }

    @Override
    @Nullable
    public MediaType contentType() {
        return GRPC_MEDIA_TYPE;
    }

    @Override
    public long contentLength() {
        return this.contentLength;
    }

    @Override
    public void writeTo(BufferedSink sink2) throws IOException {
        if (this.compressor == null) {
            sink2.writeByte(0);
            sink2.writeInt(this.messageSize);
            this.marshaler.writeBinaryTo(sink2.outputStream());
        } else {
            try (Buffer compressedBody = new Buffer();){
                try (BufferedSink compressedSink = Okio.buffer(Okio.sink(this.compressor.compress(compressedBody.outputStream())));){
                    this.marshaler.writeBinaryTo(compressedSink.outputStream());
                }
                sink2.writeByte(1);
                int compressedBytes = (int)compressedBody.size();
                sink2.writeInt(compressedBytes);
                sink2.write(compressedBody, (long)compressedBytes);
            }
        }
    }
}

