/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.extension.incubator.propagation;

import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.context.Context;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.context.propagation.ContextPropagators;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.context.propagation.TextMapGetter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.extension.incubator.propagation.CaseInsensitiveMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nullable;

public final class ExtendedContextPropagators {
    private static final TextMapGetter<Map<String, String>> TEXT_MAP_GETTER = new TextMapGetter<Map<String, String>>(){

        public Set<String> keys(Map<String, String> carrier) {
            return carrier.keySet();
        }

        @Override
        @Nullable
        public String get(@Nullable Map<String, String> carrier, String key) {
            return carrier == null ? null : carrier.get(key);
        }
    };

    private ExtendedContextPropagators() {
    }

    public static Map<String, String> getTextMapPropagationContext(ContextPropagators propagators) {
        HashMap carrier = new HashMap();
        propagators.getTextMapPropagator().inject(Context.current(), carrier, (map, key, value) -> {
            if (map != null) {
                map.put(key, value);
            }
        });
        return Collections.unmodifiableMap(carrier);
    }

    public static Context extractTextMapPropagationContext(Map<String, String> carrier, ContextPropagators propagators) {
        Context current = Context.current();
        if (carrier == null) {
            return current;
        }
        CaseInsensitiveMap caseInsensitiveMap = new CaseInsensitiveMap(carrier);
        return propagators.getTextMapPropagator().extract(current, caseInsensitiveMap, TEXT_MAP_GETTER);
    }
}

