/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics;

import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.common.Clock;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.InstrumentSelector;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.SdkMeterProvider;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.View;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.export.MetricProducer;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.export.MetricReader;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.internal.debug.SourceInfo;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.internal.exemplar.ExemplarFilter;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.internal.export.CardinalityLimitSelector;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.internal.view.RegisteredView;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.resources.Resource;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Objects;

public final class SdkMeterProviderBuilder {
    private static final ExemplarFilter DEFAULT_EXEMPLAR_FILTER = ExemplarFilter.traceBased();
    private Clock clock = Clock.getDefault();
    private Resource resource = Resource.getDefault();
    private final IdentityHashMap<MetricReader, CardinalityLimitSelector> metricReaders = new IdentityHashMap();
    private final List<MetricProducer> metricProducers = new ArrayList<MetricProducer>();
    private final List<RegisteredView> registeredViews = new ArrayList<RegisteredView>();
    private ExemplarFilter exemplarFilter = DEFAULT_EXEMPLAR_FILTER;

    SdkMeterProviderBuilder() {
    }

    public SdkMeterProviderBuilder setClock(Clock clock) {
        Objects.requireNonNull(clock, "clock");
        this.clock = clock;
        return this;
    }

    public SdkMeterProviderBuilder setResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = resource;
        return this;
    }

    public SdkMeterProviderBuilder addResource(Resource resource) {
        Objects.requireNonNull(resource, "resource");
        this.resource = this.resource.merge(resource);
        return this;
    }

    SdkMeterProviderBuilder setExemplarFilter(ExemplarFilter filter) {
        this.exemplarFilter = filter;
        return this;
    }

    public SdkMeterProviderBuilder registerView(InstrumentSelector selector, View view) {
        Objects.requireNonNull(selector, "selector");
        Objects.requireNonNull(view, "view");
        this.registeredViews.add(RegisteredView.create(selector, view, view.getAttributesProcessor(), view.getCardinalityLimit(), SourceInfo.fromCurrentStack()));
        return this;
    }

    public SdkMeterProviderBuilder registerMetricReader(MetricReader reader) {
        this.metricReaders.put(reader, CardinalityLimitSelector.defaultCardinalityLimitSelector());
        return this;
    }

    SdkMeterProviderBuilder registerMetricReader(MetricReader reader, CardinalityLimitSelector cardinalityLimitSelector) {
        this.metricReaders.put(reader, cardinalityLimitSelector);
        return this;
    }

    public SdkMeterProviderBuilder registerMetricProducer(MetricProducer metricProducer) {
        this.metricProducers.add(metricProducer);
        return this;
    }

    public SdkMeterProvider build() {
        return new SdkMeterProvider(this.registeredViews, this.metricReaders, this.metricProducers, this.clock, this.resource, this.exemplarFilter);
    }
}

