/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.internal.aggregator;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public final class ExplicitBucketHistogramUtils {
    public static final List<Double> DEFAULT_HISTOGRAM_BUCKET_BOUNDARIES = Collections.unmodifiableList(Arrays.asList(0.0, 5.0, 10.0, 25.0, 50.0, 75.0, 100.0, 250.0, 500.0, 750.0, 1000.0, 2500.0, 5000.0, 7500.0, 10000.0));

    private ExplicitBucketHistogramUtils() {
    }

    public static double[] createBoundaryArray(List<Double> boundaries) {
        ExplicitBucketHistogramUtils.validateBucketBoundaries(boundaries);
        return boundaries.stream().mapToDouble(i -> i).toArray();
    }

    public static int findBucketIndex(double[] boundaries, double value) {
        for (int i = 0; i < boundaries.length; ++i) {
            if (!(value <= boundaries[i])) continue;
            return i;
        }
        return boundaries.length;
    }

    public static void validateBucketBoundaries(List<Double> boundaries) {
        for (double v : boundaries) {
            if (!Double.isNaN(v)) continue;
            throw new IllegalArgumentException("invalid bucket boundary: NaN");
        }
        for (int i = 1; i < boundaries.size(); ++i) {
            if (!(boundaries.get(i - 1) >= boundaries.get(i))) continue;
            throw new IllegalArgumentException("Bucket boundaries must be in increasing order: " + boundaries.get(i - 1) + " >= " + boundaries.get(i));
        }
        if (!boundaries.isEmpty()) {
            if (boundaries.get(0) == Double.NEGATIVE_INFINITY) {
                throw new IllegalArgumentException("invalid bucket boundary: -Inf");
            }
            if (boundaries.get(boundaries.size() - 1) == Double.POSITIVE_INFINITY) {
                throw new IllegalArgumentException("invalid bucket boundary: +Inf");
            }
        }
    }
}

