/*
 * Decompiled with CFR 0.152.
 */
package io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.internal.data;

import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.api.common.Attributes;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.internal.DynamicPrimitiveLongList;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.data.DoubleExemplarData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.data.HistogramPointData;
import io.prometheus.metrics.shaded.io_opentelemetry_1_36_0.sdk.metrics.internal.data.HistogramPointDataValidations;
import java.util.Collections;
import java.util.List;

public final class MutableHistogramPointData
implements HistogramPointData {
    private long startEpochNanos;
    private long epochNanos;
    private Attributes attributes = Attributes.empty();
    private double sum;
    private long count;
    private boolean hasMin;
    private double min;
    private boolean hasMax;
    private double max;
    private List<Double> boundaries = Collections.emptyList();
    private final DynamicPrimitiveLongList counts;
    private List<DoubleExemplarData> exemplars = Collections.emptyList();

    public MutableHistogramPointData(int buckets) {
        this.counts = DynamicPrimitiveLongList.ofSubArrayCapacity(buckets);
        this.counts.resizeAndClear(buckets);
    }

    public MutableHistogramPointData set(long startEpochNanos, long epochNanos, Attributes attributes, double sum, boolean hasMin, double min, boolean hasMax, double max, List<Double> boundaries, long[] counts, List<DoubleExemplarData> exemplars) {
        int i;
        if (this.counts.size() != boundaries.size() + 1) {
            throw new IllegalArgumentException("invalid boundaries: size should be " + (this.counts.size() - 1) + " but was " + boundaries.size());
        }
        if (this.counts.size() != counts.length) {
            throw new IllegalArgumentException("invalid counts: size should be " + this.counts.size() + " but was " + counts.length);
        }
        HistogramPointDataValidations.validateIsStrictlyIncreasing(boundaries);
        HistogramPointDataValidations.validateFiniteBoundaries(boundaries);
        long totalCount = 0L;
        for (i = 0; i < counts.length; ++i) {
            totalCount += counts[i];
        }
        this.startEpochNanos = startEpochNanos;
        this.epochNanos = epochNanos;
        this.attributes = attributes;
        this.sum = sum;
        this.count = totalCount;
        this.hasMin = hasMin;
        this.min = min;
        this.hasMax = hasMax;
        this.max = max;
        this.boundaries = boundaries;
        for (i = 0; i < counts.length; ++i) {
            this.counts.setLong(i, counts[i]);
        }
        this.exemplars = exemplars;
        return this;
    }

    @Override
    public long getStartEpochNanos() {
        return this.startEpochNanos;
    }

    @Override
    public long getEpochNanos() {
        return this.epochNanos;
    }

    @Override
    public Attributes getAttributes() {
        return this.attributes;
    }

    @Override
    public double getSum() {
        return this.sum;
    }

    @Override
    public long getCount() {
        return this.count;
    }

    @Override
    public boolean hasMin() {
        return this.hasMin;
    }

    @Override
    public double getMin() {
        return this.min;
    }

    @Override
    public boolean hasMax() {
        return this.hasMax;
    }

    @Override
    public double getMax() {
        return this.max;
    }

    @Override
    public List<Double> getBoundaries() {
        return this.boundaries;
    }

    @Override
    public List<Long> getCounts() {
        return this.counts;
    }

    @Override
    public List<DoubleExemplarData> getExemplars() {
        return this.exemplars;
    }

    public String toString() {
        return "MutableHistogramPointData{startEpochNanos=" + this.startEpochNanos + ", epochNanos=" + this.epochNanos + ", attributes=" + this.attributes + ", sum=" + this.sum + ", count=" + this.count + ", hasMin=" + this.hasMin + ", min=" + this.min + ", hasMax=" + this.hasMax + ", max=" + this.max + ", boundaries=" + this.boundaries + ", counts=" + this.counts + ", exemplars=" + this.exemplars + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof HistogramPointData) {
            HistogramPointData that = (HistogramPointData)o;
            return this.startEpochNanos == that.getStartEpochNanos() && this.epochNanos == that.getEpochNanos() && this.attributes.equals(that.getAttributes()) && Double.doubleToLongBits(this.sum) == Double.doubleToLongBits(that.getSum()) && this.count == that.getCount() && this.hasMin == that.hasMin() && Double.doubleToLongBits(this.min) == Double.doubleToLongBits(that.getMin()) && this.hasMax == that.hasMax() && Double.doubleToLongBits(this.max) == Double.doubleToLongBits(that.getMax()) && this.boundaries.equals(that.getBoundaries()) && this.counts.equals(that.getCounts()) && this.exemplars.equals(that.getExemplars());
        }
        return false;
    }

    public int hashCode() {
        int hashcode = 1;
        hashcode *= 1000003;
        hashcode ^= (int)(this.startEpochNanos >>> 32 ^ this.startEpochNanos);
        hashcode *= 1000003;
        hashcode ^= (int)(this.epochNanos >>> 32 ^ this.epochNanos);
        hashcode *= 1000003;
        hashcode ^= this.attributes.hashCode();
        hashcode *= 1000003;
        hashcode ^= (int)(Double.doubleToLongBits(this.sum) >>> 32 ^ Double.doubleToLongBits(this.sum));
        hashcode *= 1000003;
        hashcode ^= (int)(this.count >>> 32 ^ this.count);
        hashcode *= 1000003;
        hashcode ^= this.hasMin ? 1231 : 1237;
        hashcode *= 1000003;
        hashcode ^= (int)(Double.doubleToLongBits(this.min) >>> 32 ^ Double.doubleToLongBits(this.min));
        hashcode *= 1000003;
        hashcode ^= this.hasMax ? 1231 : 1237;
        hashcode *= 1000003;
        hashcode ^= (int)(Double.doubleToLongBits(this.max) >>> 32 ^ Double.doubleToLongBits(this.max));
        hashcode *= 1000003;
        hashcode ^= this.boundaries.hashCode();
        hashcode *= 1000003;
        hashcode ^= this.counts.hashCode();
        hashcode *= 1000003;
        return hashcode ^= this.exemplars.hashCode();
    }
}

